package com.rv.camp.adapter;


import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.camp.R;
import com.rv.camp.bean.CampTypeBean;

/**
 * 营地类型列表
 */

public class CampTypeListAdapter extends BaseQuickAdapter<CampTypeBean.DataBean, BaseViewHolder> {
    private int selectPosition;

    public CampTypeListAdapter() {
        super(R.layout.rv_item_camp_type_list);
    }
    @Override
    protected void convert(BaseViewHolder helper, final CampTypeBean.DataBean item) {
        helper.setText(R.id.tv_type_name,item.getName());

        if(selectPosition==mData.indexOf(item)){
            helper.setVisible(R.id.iv_select,true);
            helper.setTextColor(R.id.tv_type_name,mContext.getResources().getColor(R.color.gray_FFB74B));
        }else {
            helper.setVisible(R.id.iv_select,false);
            helper.setTextColor(R.id.tv_type_name,mContext.getResources().getColor(R.color.textGray));
        }
    }


    public void setSelectPosition(int position){
        this.selectPosition=position;
        notifyDataSetChanged();
    }
}
