package com.rv.component.utils.log;

import android.os.Process;
import android.text.TextUtils;
import com.rv.component.utils.LogUtil;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

/*****
 * 构建打印的前缀
 */
public class LogFormatter {

    private final String formatter;

    public LogFormatter() {
        this.formatter = "yyyy-MM-dd HH:mm:ss.SSSZ";
    }

    public LogFormatter(String paramString) {
        if (!TextUtils.isEmpty(paramString)) {
            this.formatter = paramString;
            return;
        }
        this.formatter = "yyyy-MM-dd HH:mm:ss.SSSZ";
    }

    public String format(LogLevel level, String tag, String msg) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(level.getType())
                .append("\t")
                .append(formatDate(new Date(System.currentTimeMillis()), this.formatter))
                .append("\t")
                .append(Process.myPid())
                .append("\t")
                .append(Process.myTid())
                .append("\t")
                .append(tag)
                .append("\t")
                .append(msg)
                .append("\r\n");
        return buffer.toString();
    }

    public String formatDate() {
        return new SimpleDateFormat("yyyy-MM-dd").format(new Date(System.currentTimeMillis()));
    }

    public String formatDate(Date paramDate, String paramString) {
        if (paramDate == null) {
            return "";
        }
        if (TextUtils.isEmpty(paramString)) {
            return "";
        }
        try {
            return new SimpleDateFormat(paramString, Locale.ENGLISH).format(paramDate);
        } catch (Exception e) {
            LogUtil.e(e.toString());
        }
        return "";
    }
}
