package com.rv.component.utils;

public class LocationUtils {

    private static final double EARTH_RADIUS = 6371393; // 平均半径,单位：m

    /**
     * 通过AB点经纬度获取距离
     *
     * @return 距离(单位 ： 米)
     */
    public static double getDistance(double lat_a, double lng_a, double lat_b, double lng_b) {
        // 经纬度（角度）转弧度。弧度用作参数，以调用Math.cos和Math.sin
        double radiansAX = Math.toRadians(lng_a); // A经弧度
        double radiansAY = Math.toRadians(lat_a); // A纬弧度
        double radiansBX = Math.toRadians(lng_b); // B经弧度
        double radiansBY = Math.toRadians(lat_b); // B纬弧度

        // 公式中“cosβ1cosβ2cos（α1-α2）+sinβ1sinβ2”的部分，得到∠AOB的cos值
        double cos = Math.cos(radiansAY) * Math.cos(radiansBY) * Math.cos(radiansAX - radiansBX)
                + Math.sin(radiansAY) * Math.sin(radiansBY);
        double acos = Math.acos(cos); // 反余弦值
        return EARTH_RADIUS * acos; // 最终结果
    }
}
