package com.rv.component.utils;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.widget.Toast;

/**
 * 复制内容到剪贴版
 */

public class ClipboardUtil {
    public static void setText(Context baseContext, String text) {
        //从API11开始android推荐使用android.content.ClipboardManager
        //为了兼容低版本我们这里使用旧版的android.text.ClipboardManager，虽然提示deprecated，但不影响使用。
        ClipboardManager cm = (ClipboardManager) baseContext.getSystemService(Context.CLIPBOARD_SERVICE);
        //将文本内容放到系统剪贴板里。
//      //老的API，被弃用
//        if (cm != null) {
//            cm.setText(text);
//        } else {
//            Toast.makeText(baseContext, "Exception:ClipboardManager==null", Toast.LENGTH_SHORT).show();
//        }
        //创建ClipData对象
        ClipData clipData = ClipData.newPlainText(text, text);
        //添加ClipData对象到剪切板中
        if (cm != null) {
            cm.setPrimaryClip(clipData);
            Toast.makeText(baseContext, "复制成功！", Toast.LENGTH_SHORT).show();
        } else {
            Toast.makeText(baseContext, "复制失败！", Toast.LENGTH_SHORT).show();
        }
    }
}
