package com.rv.component.dialog;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;

import com.ruiwenliu.wrapper.dialog.BaseDialog;
import com.ruiwenliu.wrapper.util.ViewHolder;
import com.rv.component.control.CircleNumberProgressBar;

/**
 * 温馨提示
 */
public class ProgressBarDialog extends BaseDialog {
    CircleNumberProgressBar progressBar;

    public ProgressBarDialog(@NonNull Context context) {
        super(context);
        setDialogParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT, Gravity.CENTER);
    }

    @Override
    public void helper(ViewHolder helper) {
        super.helper(helper);
        progressBar = (CircleNumberProgressBar) helper.getView(R.id.cnpb_progress_first);
    }

    @Override
    public int getViewLayout() {
        return R.layout.dialog_progress_bar;
    }

    public void setContent(int percentage) {
        if (progressBar != null) {
            progressBar.setProgress(percentage);
        }
    }
}
