package com.base.utils.tools.android;

import android.content.Context;
import android.util.Log;
import android.widget.Toast;

import com.base.utils.Config;


/**
 * 对日志进行管理
 * 在DeBug模式开启，其它模式关闭
 *
 * @author yuyife
 *         下午2:52:59
 */
public class LogUtil {

    /**
     * 是否开启debug
     */

    /**
     * 错误
     * Write By yuyife
     * 2015-5-8
     *
     * @param clazz
     * @param msg
     */
    public static void err(Class<?> clazz, String msg) {
        if (Config.isPrint) {
            if (msg.length() > Config.LOG_MAX_LENGTH) {
                for (int i = 0; i < msg.length(); i += Config.LOG_MAX_LENGTH) {
                    if (i + Config.LOG_MAX_LENGTH < msg.length()) {
                        Log.e(clazz.getSimpleName() + "===:" + i, msg.substring(i, i + 3000));
                    } else {
                        Log.e(clazz.getSimpleName() + "===:" + i, msg.substring(i, msg.length()));
                    }
                }
            } else {
                Log.e(clazz.getSimpleName(), msg);
            }
        }
    }
    /**
     * 是否开启debug
     */

    /**
     * 错误
     * Write By yuyife
     * 2015-5-8
     *
     * @param clazz
     * @param msg
     */
    public static void e(Class<?> clazz, String msg) {
        if (Config.isPrint) {
            if (msg.length() > Config.LOG_MAX_LENGTH) {
                for (int i = 0; i < msg.length(); i += Config.LOG_MAX_LENGTH) {
                    if (i + Config.LOG_MAX_LENGTH < msg.length()) {
                        Log.e(clazz.getSimpleName() + "===:" + i, msg.substring(i, i + 3000));
                    } else {
                        Log.e(clazz.getSimpleName() + "===:" + i, msg.substring(i, msg.length()));
                    }
                }
            } else {
                Log.e(clazz.getSimpleName(), msg);
            }
        }
    }


    /**
     * 信息
     * Write By yuyife
     * 2015-5-8
     *
     * @param clazz
     * @param msg
     */
    public static void i(Class<?> clazz, String msg) {
        if (Config.isPrint) {
            Log.i(clazz.getSimpleName(), msg + "");
        }
    }

    /**
     * Debug
     * Write By yuyife
     * 2015-5-8
     *
     * @param clazz
     * @param msg
     */
    public static void d(Class<?> clazz, String msg) {
        if (Config.isPrint) {
            Log.i(clazz.getSimpleName(), msg + "");
        }
    }

    /**
     * 警告
     * Write By yuyife
     * 2015-5-8
     *
     * @param clazz
     * @param msg
     */
    public static void w(Class<?> clazz, String msg) {
        if (Config.isPrint) {
            Log.w(clazz.getSimpleName(), msg + "");
        }
    }

    /**
     * showToast
     * Write By yuyife
     * 2015-5-8
     *
     * @param context
     * @param msg
     */
    public static void t(Context context, String msg) {
        if (Config.isPrint) {
            Toast.makeText(context, msg + "", Toast.LENGTH_SHORT).show();
        }
    }
}
