package com.base.utils.tools.android;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;

import java.io.IOException;
import java.io.InputStream;

/**
 * assets 工具
 */

public class AssetsUtil {
    public static Bitmap getAssetsBitmap(Context context, String path) {
        AssetManager assetManager = context.getAssets();
        try {
            InputStream inputStream = assetManager.open(path);
            return BitmapFactory.decodeStream(inputStream);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
    public static InputStream getAssets(Context context, String path) {
        AssetManager assetManager = context.getAssets();
        try {
            return assetManager.open(path);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}
