package com.base.utils.base;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.multidex.MultiDex;

import com.base.utils.tools.android.AndroidDeviceUtil;
import com.base.utils.tools.thread.ThreadPoolProxyFactory;

/**
 * App实例
 */

public abstract class BaseApp extends Application {
    //主线程的handler
    private static Handler mMainHandler;

    public static Handler getMainHandler() {
        if (mMainHandler != null) {
            return mMainHandler;
        }
        return new Handler(Looper.getMainLooper());
    }



    @Override
    public void onCreate() {
        super.onCreate();
        mMainHandler = new Handler(Looper.getMainLooper());

        ThreadPoolProxyFactory.getNormalThreadPoolProxy().execute(new Runnable() {
            @Override
            public void run() {
                deviceInfo = new AndroidDeviceUtil.MobileDeviceInfo(BaseApp.this);
            }
        });
    }

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        //方法数超过65553
        MultiDex.install(this);
    }

    private static AndroidDeviceUtil.MobileDeviceInfo deviceInfo;

    public static AndroidDeviceUtil.MobileDeviceInfo getDeviceInfo() {

        return deviceInfo;
    }



}
