package com.ruiwenliu.wrapper.util;

import android.graphics.Bitmap;
import android.view.ViewGroup;
import android.widget.ImageView;

import com.bumptech.glide.request.target.ImageViewTarget;

public class TransformationUtil2 extends ImageViewTarget<Bitmap> {

    private ImageView target;

    public TransformationUtil2(ImageView target) {
        super(target);
        this.target = target;
    }

    @Override
    protected void setResource(Bitmap resource) {
        target.setImageBitmap(resource);

        if (resource == null) return;
        //获取原图的宽高
        int width = resource.getWidth();
        int height = resource.getHeight();

        //获取imageView的宽
        int imageViewWidth = target.getWidth();

        int imageViewHeight = (int) (imageViewWidth * 0.75);
        ViewGroup.LayoutParams params = target.getLayoutParams();
        params.height = imageViewHeight;
        target.setLayoutParams(params);
    }
}