package com.ruiwenliu.wrapper.util;

import android.content.Context;

import com.ruiwenliu.wrapper.MessageEventLogout;
import com.rv.component.utils.Cookie;
import com.rv.component.utils.RvCache;
import com.yuyife.okgo.OkGoUtil;

import org.greenrobot.eventbus.EventBus;

import me.leolin.shortcutbadger.ShortcutBadger;

public class AppUtils {

    public static void logout(Context context) {
        UtilsManager.getInstance(context).clearShareData("city_json");
        UtilsManager.getInstance(context).setShNull();
        RvCache.getInstance().clear();
        Cookie.clear(context);
        OkGoUtil.clearToken();
        EventBus.getDefault().post(new MessageEventLogout());
    }

    /********
     * 设置桌面未读消息数
     * @param count
     */
    public static void setBadger(Context context, int count) {
        if (ShortcutBadger.isBadgeCounterSupported(context)) {
            if (count > 0) {
                ShortcutBadger.applyCount(context, count);
            } else {
                ShortcutBadger.removeCount(context);
            }
        }
    }
}
