package com.ruiwenliu.wrapper.base.swipe;

import android.os.Bundle;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import android.view.View;


import com.ruiwenliu.wrapper.base.BaseFragment;
import com.ruiwenliu.wrapper.base.swipe.core.ISwipeBackFragment;
import com.ruiwenliu.wrapper.base.swipe.core.SwipeBackFragmentDelegate;
import com.ruiwenliu.wrapper.base.swipe.core.SwipeBackLayout;
import com.ruiwenliu.wrapper.presenter.MvpPresenter;

/**
 * Created by ruiwen
 * Data:2018/8/13 0013
 * Email:1054750389@qq.com
 * Desc:滑动的Fragment
 */

public abstract class SwipeBackFragment<P extends MvpPresenter> extends BaseFragment<P> implements ISwipeBackFragment {
    private SwipeBackFragmentDelegate mDelegate;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mDelegate = new SwipeBackFragmentDelegate(this);
        mDelegate.onCreate(savedInstanceState);
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        mDelegate.onViewCreated(view, savedInstanceState);
    }

    @Override
    public View attachToSwipeBack(View view) {
        return mDelegate.attachToSwipeBack(view);
    }

    @Override
    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        mDelegate.onHiddenChanged(hidden);
    }

    public SwipeBackLayout getSwipeBackLayout() {
        return mDelegate.getSwipeBackLayout();
    }

    /**
     * 是否可滑动
     *
     * @param enable
     */
    public void setSwipeBackEnable(boolean enable) {
        mDelegate.setSwipeBackEnable(enable);
    }

    @Override
    public void setEdgeLevel(SwipeBackLayout.EdgeLevel edgeLevel) {
        mDelegate.setEdgeLevel(edgeLevel);
    }

    @Override
    public void setEdgeLevel(int widthPixel) {
        mDelegate.setEdgeLevel(widthPixel);
    }

    /**
     * Set the offset of the parallax slip.
     */
    public void setParallaxOffset(@FloatRange(from = 0.0f, to = 1.0f) float offset) {
        mDelegate.setParallaxOffset(offset);
    }

    @Override
    public void onDestroyView() {
        mDelegate.onDestroyView();
        super.onDestroyView();
    }
}
