package com.xxfc.rv.other;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;

import com.rv.home.rv.module.ui.main.home.order.EvaluationActivity;
import com.rv.home.rv.module.ui.main.home.order.MemberOrderDetailsActivity;
import com.rv.home.rv.module.ui.main.home.order.OrderDetailActivity;
import com.rv.home.rv.module.ui.main.home.order.OrderListActivity;
import com.rv.home.rv.module.ui.main.home.order.TravelOrderDetailsActivity;
import com.rv.rvmine.traveler.CollectionActivity;
import com.rv.share.ShareActivity;
import com.xxfc.rv.MainActivity;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Iterator;
import java.util.List;

import cn.jpush.android.api.JPushInterface;

/**
 * 自定义接收器
 * <p>
 * 如果不定义这个 Receiver，则：
 * 1) 默认用户会打开主界面
 * 2) 接收不到自定义消息
 */
public class MyReceiver extends BroadcastReceiver {
    private static final String TAG = "tagtag";

    @Override
    public void onReceive(Context context, Intent intent) {
        try {
            Bundle bundle = intent.getExtras();
            Log.d(TAG, "[MyReceiver] onReceive - " + intent.getAction() + ", extras: " + printBundle(bundle));

            if (JPushInterface.ACTION_REGISTRATION_ID.equals(intent.getAction())) {
                String regId = bundle.getString(JPushInterface.EXTRA_REGISTRATION_ID);
                Log.d(TAG, "[MyReceiver] 接收Registration Id : " + regId);
                //send the Registration Id to your server...

            } else if (JPushInterface.ACTION_MESSAGE_RECEIVED.equals(intent.getAction())) {
                Log.d(TAG, "[MyReceiver] 接收到推送下来的自定义消息: " + bundle.getString(JPushInterface.EXTRA_MESSAGE));

            } else if (JPushInterface.ACTION_NOTIFICATION_RECEIVED.equals(intent.getAction())) {
                Log.d(TAG, "[MyReceiver] 接收到推送下来的通知");
                int notifactionId = bundle.getInt(JPushInterface.EXTRA_NOTIFICATION_ID);
                Log.d(TAG, "[MyReceiver] 接收到推送下来的通知的ID: " + notifactionId);

            } else if (JPushInterface.ACTION_NOTIFICATION_OPENED.equals(intent.getAction())) {
                Log.d(TAG, "[MyReceiver] 用户点击打开了通知");

                //获取推送消息的方法
                String extra = bundle.getString(JPushInterface.EXTRA_EXTRA);
                JSONObject jsonObject = new JSONObject(extra);
                String onclickType = jsonObject.getString("onclickType");
                String orderId = "";
                if (jsonObject.has("orderId")) {
                    orderId = jsonObject.getString("orderId");
                }

                if (isAppRunning(context, "com.xxfc.rv")) {          //判断App是否在运行
                    Intent intent2 = new Intent();
                    intent2.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP);
                    switch (onclickType) {
                        case "1":
                            //租车订单详情
                            intent2.putExtra("no", orderId);
                            intent2.setClass(context, OrderDetailActivity.class);
                            context.startActivity(intent2);
                            break;
                        case "2":
                            //旅游订单详情
                            intent2.putExtra("no", orderId);
                            intent2.setClass(context, TravelOrderDetailsActivity.class);
                            context.startActivity(intent2);
                            break;
                        case "3":
                            //租车订单评价
                            intent2.putExtra("no", orderId);
                            intent2.setClass(context, EvaluationActivity.class);
                            context.startActivity(intent2);
                            break;
                        case "4":
                            //旅游订单评价
                            intent2.putExtra("no", orderId);
                            intent2.setClass(context, EvaluationActivity.class);
                            context.startActivity(intent2);
                            break;
                        case "5":
                            //会员订单详情
                            intent2.putExtra("no", orderId);
                            intent2.setClass(context, MemberOrderDetailsActivity.class);
                            context.startActivity(intent2);
                            break;
                        default:
                            intent2.setClass(context, MainActivity.class);
                            context.startActivity(intent2);
                            break;
                    }

                } else {

                    Intent intent3 = new Intent();
                    intent3.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP);
                    switch (onclickType) {
                        case "1":
                            //租车订单详情
                            context.startActivity(MainActivity.getIntent(context));
                            intent3.putExtra("no", orderId);
                            intent3.setClass(context, OrderDetailActivity.class);
                            context.startActivity(intent3);
                            break;
                        case "2":
                            //旅游订单详情
                            context.startActivity(MainActivity.getIntent(context));
                            intent3.putExtra("no", orderId);
                            intent3.setClass(context, TravelOrderDetailsActivity.class);
                            context.startActivity(intent3);
                            break;
                        case "3":
                            //租车订单评价
                            context.startActivity(MainActivity.getIntent(context));
                            intent3.putExtra("no", orderId);
                            intent3.setClass(context, EvaluationActivity.class);
                            context.startActivity(intent3);
                            break;
                        case "4":
                            //旅游订单评价
                            context.startActivity(MainActivity.getIntent(context));
                            intent3.putExtra("no", orderId);
                            intent3.setClass(context, EvaluationActivity.class);
                            context.startActivity(intent3);
                            break;
                        case "5":
                            //会员订单详情
                            context.startActivity(MainActivity.getIntent(context));
                            intent3.putExtra("no", orderId);
                            intent3.setClass(context, MemberOrderDetailsActivity.class);
                            context.startActivity(intent3);
                            break;
                        default:
                            intent3.setClass(context, MainActivity.class);
                            context.startActivity(intent3);
                            break;
                    }
                }

            } else if (JPushInterface.ACTION_RICHPUSH_CALLBACK.equals(intent.getAction())) {
                Log.d(TAG, "[MyReceiver] 用户收到到RICH PUSH CALLBACK: " + bundle.getString(JPushInterface.EXTRA_EXTRA));
                //在这里根据 JPushInterface.EXTRA_EXTRA 的内容处理代码，比如打开新的Activity， 打开一个网页等..

            } else if (JPushInterface.ACTION_CONNECTION_CHANGE.equals(intent.getAction())) {
                boolean connected = intent.getBooleanExtra(JPushInterface.EXTRA_CONNECTION_CHANGE, false);
                Log.w(TAG, "[MyReceiver]" + intent.getAction() + " connected state change to " + connected);
            } else {
                Log.d(TAG, "[MyReceiver] Unhandled intent - " + intent.getAction());
            }
        } catch (Exception e) {

        }

    }

    // 打印所有的 intent extra 数据
    private static String printBundle(Bundle bundle) {
        StringBuilder sb = new StringBuilder();
        for (String key : bundle.keySet()) {
            if (key.equals(JPushInterface.EXTRA_NOTIFICATION_ID)) {
                sb.append("\nkey:" + key + ", value:" + bundle.getInt(key));
            } else if (key.equals(JPushInterface.EXTRA_CONNECTION_CHANGE)) {
                sb.append("\nkey:" + key + ", value:" + bundle.getBoolean(key));
            } else if (key.equals(JPushInterface.EXTRA_EXTRA)) {
                if (TextUtils.isEmpty(bundle.getString(JPushInterface.EXTRA_EXTRA))) {
                    Log.i(TAG, "This message has no Extra data");
                    continue;
                }

                try {
                    JSONObject json = new JSONObject(bundle.getString(JPushInterface.EXTRA_EXTRA));
                    Iterator<String> it = json.keys();

                    while (it.hasNext()) {
                        String myKey = it.next();
                        sb.append("\nkey:" + key + ", value: [" +
                                myKey + " - " + json.optString(myKey) + "]");
                    }
                } catch (JSONException e) {
                    Log.e(TAG, "Get message extra JSON error!");
                }

            } else {
                sb.append("\nkey:" + key + ", value:" + bundle.get(key));
            }
        }
        return sb.toString();
    }


    /**
     * 方法描述：判断某一应用是否正在运行
     *
     * @param context     上下文
     * @param packageName 应用的包名
     * @return true 表示正在运行，false 表示没有运行
     */
    public static boolean isAppRunning(Context context, String packageName) {
        ActivityManager am = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        List<ActivityManager.RunningTaskInfo> list = am.getRunningTasks(100);
        if (list.size() <= 0) {
            return false;
        }
        for (ActivityManager.RunningTaskInfo info : list) {
            if (info.baseActivity.getPackageName().equals(packageName)) {
                return true;
            }
        }
        return false;
    }

}
