package com.xxfc.rv.fragment;

import android.graphics.Color;
import android.os.Bundle;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseFragment;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.rv.share.utils.TransformationUtils;
import com.xxfc.rv.R;

public class GuideSecondFragment extends BaseFragment<CommonPresenter> {
    private ImageView imageView;
    private TextView textView1;
    private TextView textView2;

    public GuideSecondFragment(){

    }
    @Override
    public int getViewLayout() {
        return R.layout.fragment_guide;
    }

    @Override
    protected void initView(Bundle savedInstanceState) {
        imageView = getView().findViewById(R.id.image);
        textView1 = getView().findViewById(R.id.textview1);
        textView2 = getView().findViewById(R.id.textview2);
        textView1.setText("全国租车 异地取还");
        SpannableStringBuilder style=new SpannableStringBuilder("数百个城市自由来回\n门店遍布全国");
//        style.setSpan(new ForegroundColorSpan(Color.RED),2,5,Spannable.SPAN_EXCLUSIVE_INCLUSIVE);
//        style.setSpan(new ForegroundColorSpan(Color.RED),10,13,Spannable.SPAN_EXCLUSIVE_INCLUSIVE);
        textView2.setText(style);
        Glide.with(getActivity())
                .asBitmap()
                .load(R.drawable.icon_guide2)
                .into(new TransformationUtils(imageView));
    }

    @Override
    protected void loadData(Bundle savedInstanceState) {

    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }
}
