package com.xxfc.rv;

import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import com.ruiwenliu.wrapper.base.BaseActivity;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.component.utils.CacheEnum;
import com.rv.component.utils.LogUtil;
import com.rv.component.utils.RvCache;
import com.rv.im.AppConfig;
import com.rv.im.bean.ImConfig;
import com.rv.im.bean.ImConfigBean;
import com.xxfc.rv.presenter.WelcomePresenter;

public class WelcomeActivity extends BaseActivity<WelcomePresenter> {

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        if (requestType == 0) {
            ImConfigBean bean = (ImConfigBean) result;
            ImConfig config;
            if (bean != null && bean.resultCode == 1 && ((ImConfigBean) result).getData() != null) {
                LogUtil.e("zq", "获取网络配置成功，使用服务端返回的配置并更新本地配置");
                config = bean.getData();
                AppConfig appConfig = AppConfig.initConfig(config);
                RvCache.getInstance().save(appConfig, CacheEnum.IM_CONFIG);
            }
        }
    }

    @Override
    protected int setLayout() {
        return R.layout.rv_act_weclome;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        showTitle(false);//隐藏菜单栏
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        mPresenter.saveOnclick("8", "");
        mPresenter.privacyConsent();
        mPresenter.getImConfig();
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 21) {
            getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_FULLSCREEN);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == mPresenter.CODE_REQUEST_POISITION) {
            mPresenter.permissionProcess();
        }
    }
}
