package com.xxfc.rv;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.TextView;

import com.ruiwenliu.wrapper.dialog.BaseDialog;

public class PrivacyThirdTipsDialog extends BaseDialog {

    public PrivacyThirdTipsDialog(@NonNull Context context) {
        super(context);
        setDialogParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT, Gravity.CENTER);
    }

    public PrivacyThirdTipsDialog(Context context, int themeResId) {
        super(context, themeResId);
        setDialogParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT, Gravity.CENTER);
    }

    @Override
    public int getViewLayout() {
        return R.layout.dialog_privacy_third_tips;
    }

    public static class Builder {

        private Context mContext;
        private Button btnExit, btnWatchAgreement;
        private TextView txtContent;
        private PrivacyThirdTipsDialog dialog;
        private PrivacyListener mListener;

        public Builder(Context context, PrivacyListener listener) {
            mContext = context;
            this.mListener = listener;
        }

        public interface DownloadListener {
            void download();
        }

        public Builder show() {
            final PrivacyThirdTipsDialog dialog = create();
            dialog.show();
            return this;
        }

        /**
         * 创建定制的对话框
         */
        public PrivacyThirdTipsDialog create() {
            LayoutInflater inflater = (LayoutInflater) mContext.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            dialog = new PrivacyThirdTipsDialog(mContext, R.style.DialogActivityTheme);
            // 获取对话框的布局
            View layout = inflater.inflate(R.layout.dialog_privacy_third_tips, null);
            // 为对话框添加布局和设置大小
            dialog.addContentView(layout, new WindowManager.LayoutParams(WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.WRAP_CONTENT));
            this.btnExit = layout.findViewById(R.id.btn_exit);
            this.btnWatchAgreement = layout.findViewById(R.id.btn_watch_agreement);
            this.btnWatchAgreement.setOnClickListener(v -> {
                if (mListener != null) mListener.watchAgreement();
                dialog.dismiss();
            });

            this.btnExit.setOnClickListener(v -> {
                if (mListener != null) mListener.exit();
                dialog.dismiss();
            });

            dialog.setCancelable(false);
            dialog.setContentView(layout);
            return dialog;
        }
    }

    public interface PrivacyListener {

        void watchAgreement();

        void exit();
    }

}
