package com.xxfc.rv;

import android.content.Context;
import android.content.Intent;
import android.support.v4.view.ViewPager;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;

import com.ruiwenliu.wrapper.adapter.TabAdapter;
import com.ruiwenliu.wrapper.base.BaseActivity;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseWrapperFragment;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.xxfc.rv.fragment.GuideFirstFragment;
import com.xxfc.rv.fragment.GuideFourthFragment;
import com.xxfc.rv.fragment.GuideSecondFragment;
import com.xxfc.rv.fragment.GuideThirdFragment;

import java.util.ArrayList;
import java.util.List;

public class GuideActivity extends BaseActivity<CommonPresenter> {

    private ViewPager viewPager;
    private ImageView imgSelect;
    private Button btnSkip;
    private int[] poits = {
            R.drawable.icon_guide_circle1,
            R.drawable.icon_guide_circle2,
            R.drawable.icon_guide_circle3,
            R.drawable.icon_guide_circle4
    };

    public static Intent getIntent(Context context) {
        return new Intent(context, GuideActivity.class);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_guide;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setVisibility(View.GONE);
        viewPager = findViewById(R.id.viewpager);
        imgSelect = findViewById(R.id.img_select);
        btnSkip = findViewById(R.id.btn_skip);
        TabAdapter mAdapter = new TabAdapter(getSupportFragmentManager(), getListFragment());
        viewPager.setOffscreenPageLimit(4);
        viewPager.setAdapter(mAdapter);
        viewPager.setCurrentItem(0);
        imgSelect.setImageResource(poits[0]);
        viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int i, float v, int i1) {

            }

            @Override
            public void onPageSelected(int i) {
                imgSelect.setImageResource(poits[i]);
            }

            @Override
            public void onPageScrollStateChanged(int i) {

            }
        });
        btnSkip.setOnClickListener(v -> {
            startActivity(MainActivity.getIntent(getApplicationContext()));
            mPresenter.getView().onShowLoading();
            new Thread(() -> {
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finish();
            }).start();

        });
    }

    @Override
    public void finish() {
        mPresenter.getView().onHideLoading();
        super.finish();
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {

    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    private List<BaseWrapperFragment> getListFragment() {
        List<BaseWrapperFragment> list = new ArrayList<>();
        list.add(new GuideFirstFragment());
        list.add(new GuideSecondFragment());
        list.add(new GuideThirdFragment());
        list.add(new GuideFourthFragment());
        return list;
    }

    @Override
    protected void onStop() {
        super.onStop();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }
}
