package com.frame.base.activity;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.KeyEvent;

import com.base.sweetdialog.SweetDialogUtil;
import com.base.utils.base.BaseActivity;
import com.base.utils.eventbusmodel.EventRestartApp;
import com.base.utils.tools.android.ActivityUtil;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import cn.pedant.SweetAlert.SweetAlertDialog;


/**
 * 流程 在服务当中收到MIMC消息，传递过来了Code
 * 1. 用户在其他设备上登录  206
 * 2. 管理控制台中在使用了强制下线   207
 * 2. 管理控制台中删除了帐户   208
 */

public class FrameOfflineActivity extends BaseActivity {
    final public static String TYPE = "type";
    final public static int USER_LOGIN_ANOTHER_DEVICE = 206;        //用户在其他设备登录
    final public static int USER_FORCED_OFFLINE = 207;              //用户强制下线
    final public static int USER_REMOVED = 208;                     //用户被删除


    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!EventBus.getDefault().isRegistered(this)) {
            EventBus.getDefault().register(this);
        }
        setContentView(com.base.utils.R.layout.utils_offline_activity);
        onData();
        onView();
    }

    private int type = 0;
    private SweetAlertDialog sweetAlertDialog;

    @Override
    public void onData() {

        type = getIntent().getIntExtra(TYPE, 0);

        switch (type) {
            case USER_LOGIN_ANOTHER_DEVICE:
                //用户在其他设备上登录
                sweetAlertDialog = SweetDialogUtil.getErrorDialog(baseContext);
                sweetAlertDialog.setCancelable(false);
                sweetAlertDialog.setTitleText(getString(com.base.utils.R.string.resource_prompt_user_login_another_device_title))
                        .setContentText(getString(com.base.utils.R.string.resource_prompt_user_login_another_device_content))
                        .setConfirmText(getString(com.base.utils.R.string.resource_prompt_user_login_another_device_anew_login))
                        .setConfirmClickListener(new SweetAlertDialog.OnSweetClickListener() {
                            @Override
                            public void onClick(SweetAlertDialog sweetAlertDialog) {
                                //关闭所有Activity，重启
                                EventBus.getDefault().post(new EventRestartApp(EventRestartApp.Type.TYPE_RESTART_FORCE_OFFLINE));
                                sweetAlertDialog.dismissWithAnimation();
                                FrameOfflineActivity.this.finish();
                                ActivityUtil.finishAllActivity();

                            }
                        }).show();
                break;
            case USER_FORCED_OFFLINE:
                ////用户被后台强制下线
                sweetAlertDialog = SweetDialogUtil.getErrorDialog(baseContext);
                sweetAlertDialog.setCancelable(false);
                sweetAlertDialog.setTitleText(getString(com.base.utils.R.string.resource_prompt_user_forced_title))
                        .setContentText(getString(com.base.utils.R.string.resource_prompt_user_forced_offline_content))
                        .setConfirmText(getString(com.base.utils.R.string.resource_public_know))
                        .setConfirmClickListener(new SweetAlertDialog.OnSweetClickListener() {
                            @Override
                            public void onClick(SweetAlertDialog sweetAlertDialog) {
                                sweetAlertDialog.dismissWithAnimation();
                                FrameOfflineActivity.this.finish();
                                ActivityUtil.exit();
                            }
                        })
                        .show();
                break;
            case USER_REMOVED:
                //用户被后台被删除帐户
                sweetAlertDialog = SweetDialogUtil.getErrorDialog(baseContext);
                sweetAlertDialog.setCancelable(false);
                sweetAlertDialog.setTitleText(getString(com.base.utils.R.string.resource_prompt_user_removed_title))
                        .setContentText(getString(com.base.utils.R.string.resource_prompt_user_removed_content))
                        .setConfirmText(getString(com.base.utils.R.string.resource_public_know))
                        .setConfirmClickListener(new SweetAlertDialog.OnSweetClickListener() {
                            @Override
                            public void onClick(SweetAlertDialog sweetAlertDialog) {
                                sweetAlertDialog.dismissWithAnimation();
                                FrameOfflineActivity.this.finish();
                                ActivityUtil.exit();
                            }
                        })
                        .show();
                break;
        }

    }

    @Override
    public void onView() {

    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (EventBus.getDefault().isRegistered(this)) {
            EventBus.getDefault().unregister(this);
        }
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            if (sweetAlertDialog != null) {
                sweetAlertDialog.dismissWithAnimation();
            }
            EventBus.getDefault().post(new EventRestartApp(EventRestartApp.Type.TYPE_RESTART_FORCE_OFFLINE));
            FrameOfflineActivity.this.finish();
            //关闭所有Activity，重启
            ActivityUtil.finishAllActivity();

        }
        return super.onKeyDown(keyCode, event);
    }

    //收到异常捕获，用户关闭窗口并重启的事件
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onEventRestartApp(EventRestartApp restartAppEvent) {

    }

}
