/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.shareboard;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.ImageButton;
import android.widget.ImageView;

public class SocializeImageView
extends ImageButton {
    private boolean mIsSelected;
    private int mNormalColor;
    private int mPressedColor;
    private int mIconPressedColor;
    private boolean mIsPressEffect;
    private int mBgShape;
    public static int BG_SHAPE_NONE = 0;
    public static int BG_SHAPE_CIRCULAR = 1;
    public static int BG_SHAPE_ROUNDED_SQUARE = 2;
    protected Paint mNormalPaint;
    protected Paint mPressedPaint;
    private RectF mSquareRect;
    private int mAngle;

    public SocializeImageView(Context context) {
        super(context);
        this.init();
    }

    public SocializeImageView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    public SocializeImageView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init();
    }

    @TargetApi(value=21)
    public SocializeImageView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.init();
    }

    private void init() {
        if (Build.VERSION.SDK_INT < 16) {
            this.setBackgroundDrawable(null);
        } else {
            this.setBackground(null);
        }
        this.setClickable(false);
        this.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
    }

    public void setBackgroundShape(int n) {
        this.setBackgroundShape(n, 0);
    }

    public void setBackgroundShape(int n, int n2) {
        this.mBgShape = n;
        if (n != BG_SHAPE_ROUNDED_SQUARE) {
            this.mAngle = 0;
        } else {
            float f = this.getResources().getDisplayMetrics().density;
            this.mAngle = (int)((float)n2 * f + 0.5f);
        }
    }

    public void setBackgroundColor(int n) {
        this.setBackgroundColor(n, 0);
    }

    public void setBackgroundColor(int n, int n2) {
        this.mNormalColor = n;
        this.mPressedColor = n2;
        this.setPressEffectEnable(n2 != 0);
        if (this.mNormalColor != 0) {
            this.mNormalPaint = new Paint();
            this.mNormalPaint.setStyle(Paint.Style.FILL);
            this.mNormalPaint.setAntiAlias(true);
            this.mNormalPaint.setColor(n);
        }
        if (this.mPressedColor != 0) {
            this.mPressedPaint = new Paint();
            this.mPressedPaint.setStyle(Paint.Style.FILL);
            this.mPressedPaint.setAntiAlias(true);
            this.mPressedPaint.setColor(n2);
        }
    }

    public void setPressedColor(int n) {
        this.setPressEffectEnable(n != 0);
        this.mIconPressedColor = n;
    }

    public void setPressEffectEnable(boolean bl) {
        this.mIsPressEffect = bl;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (!this.mIsPressEffect) {
            return;
        }
        if (this.isPressed()) {
            if (BG_SHAPE_NONE == this.mBgShape) {
                if (this.mIconPressedColor != 0) {
                    this.setColorFilter(this.mIconPressedColor, PorterDuff.Mode.SRC_ATOP);
                }
            } else {
                this.mIsSelected = true;
                this.invalidate();
            }
        } else if (BG_SHAPE_NONE == this.mBgShape) {
            this.clearColorFilter();
        } else {
            this.mIsSelected = false;
            this.invalidate();
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mBgShape == BG_SHAPE_NONE) {
            super.onDraw(canvas);
            return;
        }
        if (this.mIsSelected) {
            if (this.mIsPressEffect && this.mPressedPaint != null) {
                if (this.mBgShape == BG_SHAPE_CIRCULAR) {
                    this.drawCircle(canvas, this.mPressedPaint);
                } else if (this.mBgShape == BG_SHAPE_ROUNDED_SQUARE) {
                    this.drawRect(canvas, this.mPressedPaint);
                }
            }
        } else if (this.mBgShape == BG_SHAPE_CIRCULAR) {
            this.drawCircle(canvas, this.mNormalPaint);
        } else if (this.mBgShape == BG_SHAPE_ROUNDED_SQUARE) {
            this.drawRect(canvas, this.mNormalPaint);
        }
        super.onDraw(canvas);
    }

    private void drawCircle(Canvas canvas, Paint paint) {
        int n = this.getMeasuredWidth() / 2;
        canvas.drawCircle((float)n, (float)n, (float)n, paint);
    }

    private void drawRect(Canvas canvas, Paint paint) {
        if (this.mSquareRect == null) {
            this.mSquareRect = new RectF();
            this.mSquareRect.left = 0.0f;
            this.mSquareRect.top = 0.0f;
            this.mSquareRect.right = this.getMeasuredWidth();
            this.mSquareRect.bottom = this.getMeasuredWidth();
        }
        canvas.drawRoundRect(this.mSquareRect, (float)this.mAngle, (float)this.mAngle, paint);
    }

    protected int dip2px(float f) {
        float f2 = this.getContext().getResources().getDisplayMetrics().density;
        return (int)(f * f2 + 0.5f);
    }
}

