/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.shareboard;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

public class IndicatorView
extends View {
    private int mIndicatorWidth;
    private int mIndicatorMargin;
    private int mPageCount;
    private int mSelectPosition;
    private float mLeftPosition;
    private Paint mSelectPaint;
    private Paint mNormalPaint;

    public IndicatorView(Context context) {
        super(context);
    }

    public IndicatorView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public IndicatorView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    @TargetApi(value=21)
    public IndicatorView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
    }

    protected void onMeasure(int n, int n2) {
        this.setMeasuredDimension(this.measureWidth(n), this.measureHeight(n2));
    }

    private int measureWidth(int n) {
        int n2 = View.MeasureSpec.getMode((int)n);
        int n3 = View.MeasureSpec.getSize((int)n);
        int n4 = this.getPaddingLeft() + this.getPaddingRight() + this.mIndicatorWidth * this.mPageCount * 2 + this.mIndicatorMargin * (this.mPageCount - 1);
        this.mLeftPosition = (float)(this.getMeasuredWidth() - n4) / 2.0f + (float)this.getPaddingLeft();
        int n5 = n2 == 0x40000000 ? Math.max(n4, n3) : (n2 == Integer.MIN_VALUE ? Math.min(n4, n3) : n4);
        return n5;
    }

    private int measureHeight(int n) {
        int n2;
        int n3 = View.MeasureSpec.getMode((int)n);
        int n4 = View.MeasureSpec.getSize((int)n);
        if (n3 == 0x40000000) {
            n2 = n4;
        } else {
            int n5 = this.getPaddingTop() + this.getPaddingBottom() + this.mIndicatorWidth * 2;
            n2 = n3 == Integer.MIN_VALUE ? Math.min(n5, n4) : n5;
        }
        return n2;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mSelectPaint == null || this.mNormalPaint == null) {
            return;
        }
        float f = this.mLeftPosition;
        f += (float)this.mIndicatorWidth;
        for (int i = 0; i < this.mPageCount; ++i) {
            canvas.drawCircle(f, (float)this.mIndicatorWidth, (float)this.mIndicatorWidth, i == this.mSelectPosition ? this.mSelectPaint : this.mNormalPaint);
            f += (float)(this.mIndicatorMargin + this.mIndicatorWidth * 2);
        }
    }

    public void setSelectedPosition(int n) {
        this.mSelectPosition = n;
        this.invalidate();
    }

    public void setPageCount(int n) {
        this.mPageCount = n;
        this.invalidate();
    }

    public void setIndicator(int n, int n2) {
        this.mIndicatorMargin = this.dip2px(n2);
        this.mIndicatorWidth = this.dip2px(n);
    }

    public void setIndicatorColor(int n, int n2) {
        this.mSelectPaint = new Paint();
        this.mSelectPaint.setStyle(Paint.Style.FILL);
        this.mSelectPaint.setAntiAlias(true);
        this.mSelectPaint.setColor(n2);
        this.mNormalPaint = new Paint();
        this.mNormalPaint.setStyle(Paint.Style.FILL);
        this.mNormalPaint.setAntiAlias(true);
        this.mNormalPaint.setColor(n);
    }

    protected int dip2px(float f) {
        float f2 = this.getContext().getResources().getDisplayMetrics().density;
        return (int)(f * f2 + 0.5f);
    }
}

