/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.search.poi;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.baidu.mapapi.search.poi.c;
import java.util.HashMap;
import java.util.Map;

public final class PoiFilter
implements Parcelable {
    private String a = "";
    private String b = "";
    private String c = "";
    private String d = "";
    private String e = "";
    private static Map<SortName, String> f = new HashMap<SortName, String>();
    public static final Parcelable.Creator<PoiFilter> CREATOR = new c();

    PoiFilter(String string, String string2, String string3, String string4, String string5) {
        this.a = string;
        this.b = string2;
        this.c = string3;
        this.e = string4;
        this.d = string5;
    }

    protected PoiFilter(Parcel parcel) {
        this.a = parcel.readString();
        this.b = parcel.readString();
        this.c = parcel.readString();
        this.e = parcel.readString();
        this.d = parcel.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.a);
        parcel.writeString(this.b);
        parcel.writeString(this.c);
        parcel.writeString(this.e);
        parcel.writeString(this.d);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)this.a)) {
            stringBuilder.append("industry_type:");
            stringBuilder.append(this.a);
            stringBuilder.append("|");
        }
        if (!TextUtils.isEmpty((CharSequence)this.b)) {
            stringBuilder.append("sort_name:");
            stringBuilder.append(this.b);
            stringBuilder.append("|");
        }
        if (!TextUtils.isEmpty((CharSequence)this.c)) {
            stringBuilder.append("sort_rule:");
            stringBuilder.append(this.c);
            stringBuilder.append("|");
        }
        if (!TextUtils.isEmpty((CharSequence)this.e)) {
            stringBuilder.append("discount:");
            stringBuilder.append(this.e);
            stringBuilder.append("|");
        }
        if (!TextUtils.isEmpty((CharSequence)this.d)) {
            stringBuilder.append("groupon:");
            stringBuilder.append(this.d);
            stringBuilder.append("|");
        }
        if (!TextUtils.isEmpty((CharSequence)stringBuilder.toString())) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static final class Builder {
        private String a;
        private String b;
        private String c;
        private String d;
        private String e;

        public Builder() {
            f.put(SortName.HotelSortName.DEFAULT, "default");
            f.put(SortName.HotelSortName.HOTEL_LEVEL, "level");
            f.put(SortName.HotelSortName.HOTEL_PRICE, "price");
            f.put(SortName.HotelSortName.HOTEL_DISTANCE, "distance");
            f.put(SortName.HotelSortName.HOTEL_HEALTH_SCORE, "health_score");
            f.put(SortName.HotelSortName.HOTEL_TOTAL_SCORE, "total_score");
            f.put(SortName.CaterSortName.DEFAULT, "default");
            f.put(SortName.CaterSortName.CATER_DISTANCE, "distance");
            f.put(SortName.CaterSortName.CATER_PRICE, "price");
            f.put(SortName.CaterSortName.CATER_OVERALL_RATING, "overall_rating");
            f.put(SortName.CaterSortName.CATER_SERVICE_RATING, "service_rating");
            f.put(SortName.CaterSortName.CATER_TASTE_RATING, "taste_rating");
            f.put(SortName.LifeSortName.DEFAULT, "default");
            f.put(SortName.LifeSortName.PRICE, "price");
            f.put(SortName.LifeSortName.LIFE_COMMENT_RATING, "comment_num");
            f.put(SortName.LifeSortName.LIFE_OVERALL_RATING, "overall_rating");
            f.put(SortName.LifeSortName.DISTANCE, "distance");
        }

        public PoiFilter build() {
            return new PoiFilter(this.a, this.b, this.c, this.e, this.d);
        }

        public Builder industryType(IndustryType industryType) {
            switch (industryType) {
                case HOTEL: {
                    this.a = "hotel";
                    break;
                }
                case CATER: {
                    this.a = "cater";
                    break;
                }
                case LIFE: {
                    this.a = "life";
                    break;
                }
                default: {
                    this.a = "";
                }
            }
            return this;
        }

        public Builder sortName(SortName sortName) {
            if (TextUtils.isEmpty((CharSequence)this.a)) {
                return this;
            }
            if (null != sortName) {
                this.b = (String)f.get(sortName);
            }
            return this;
        }

        public Builder sortRule(int n2) {
            this.c = n2 + "";
            return this;
        }

        public Builder isGroupon(boolean bl) {
            this.d = bl ? "1" : "0";
            return this;
        }

        public Builder isDiscount(boolean bl) {
            this.e = bl ? "1" : "0";
            return this;
        }
    }

    public static interface SortName {

        public static enum LifeSortName implements SortName
        {
            DEFAULT,
            PRICE,
            DISTANCE,
            LIFE_OVERALL_RATING,
            LIFE_COMMENT_RATING;

        }

        public static enum CaterSortName implements SortName
        {
            DEFAULT,
            CATER_PRICE,
            CATER_DISTANCE,
            CATER_TASTE_RATING,
            CATER_OVERALL_RATING,
            CATER_SERVICE_RATING;

        }

        public static enum HotelSortName implements SortName
        {
            DEFAULT,
            HOTEL_PRICE,
            HOTEL_DISTANCE,
            HOTEL_TOTAL_SCORE,
            HOTEL_LEVEL,
            HOTEL_HEALTH_SCORE;

        }
    }

    public static enum IndustryType {
        HOTEL,
        CATER,
        LIFE;

    }
}

