package com.rv.share.view;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.rv.component.utils.DisplayUtil;
import com.rv.share.R;

public class BillDialog extends Dialog {

    public BillDialog(@NonNull Context context) {
        super(context);
    }

    public BillDialog(Context context, int themeResId) {
        super(context, themeResId);
    }

    public static class Builder {

        private Context mContext;
        private ImageView imgClose;
        private View.OnClickListener mListener;
        private String content;
        private LinearLayout llWebview;

        public Builder(Context context, View.OnClickListener listener) {
            mContext = context;
            this.mListener = listener;
        }

        public Builder(Context context) {
            mContext = context;
        }

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public Builder show() {
            final BillDialog dialog = create();
            dialog.show();
            return this;
        }

        /**
         * 创建定制的对话框
         */
        public BillDialog create() {
            LayoutInflater inflater = (LayoutInflater) mContext.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            final BillDialog dialog = new BillDialog(mContext, R.style.DialogActivityTheme);
            // 获取对话框的布局
            View layout = inflater.inflate(R.layout.dialog_bill, null);
            // 为对话框添加布局和设置大小
            dialog.addContentView(layout, new WindowManager.LayoutParams(WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.WRAP_CONTENT));
            this.llWebview = layout.findViewById(R.id.ll_webview);
            RvWebView view = new RvWebView(mContext, listener);
            llWebview.addView(view);
            view.loadUrl("https://www.baidu.com");


            this.imgClose = layout.findViewById(R.id.img_close);
            this.imgClose.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    dialog.dismiss();
                }
            });
            //默认不能点击对话框其他区域退出 和按返回键退出
            dialog.setCancelable(true);
            dialog.setContentView(layout);
            return dialog;
        }

        private RvWebView.WebViewListener listener = new RvWebView.WebViewListener() {
            @Override
            public void share(String url, String title, String desc) {

            }

            @Override
            public void finish() {

            }
        };
    }
}
