package com.rv.share.presenter;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.view.View;
import android.widget.Toast;

import com.base.utils.ui.datetime.picker.Utils;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.share.utils.ShareUtils;
import com.rv.share.utils.StorageUtils;
import com.umeng.socialize.ShareAction;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.media.UMImage;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class ReativeBillPresenter extends CommonPresenter {

    private ShareAction shareAction = null;

    /*****
     * 保存海报
     * @param view
     */
    public void saveBill(View view) {
        if (view != null) {
            Bitmap bitmap = ShareUtils.viewConversionBitmap(view);
            File file = null;
            if (bitmap != null) {
                file = ShareUtils.saveBitmapFile(getPresenterContext(),bitmap);
            }
            if (file != null) {
                Toast.makeText(getPresenterContext(), "海报保存在" + file.getAbsolutePath(), Toast.LENGTH_LONG).show();
            }
        }
    }

    /****
     * 分享到朋友圈
     * @param view
     */
    public void shareCircle(View view) {
        if (view != null) {
            Bitmap bitmap = ShareUtils.viewConversionBitmap(view);
            File file = null;
            if (bitmap != null) {
                file = ShareUtils.saveBitmapFile(getPresenterContext(), bitmap);
            }
            if (file != null) {
                UMImage image = new UMImage(getPresenterContext(), file);//bitmap文件
                image.compressStyle = UMImage.CompressStyle.SCALE;//大小压缩，默认为大小压缩，适合普通很大的图
                image.compressStyle = UMImage.CompressStyle.QUALITY;//质量压缩，适合长图的分享
                image.compressFormat = Bitmap.CompressFormat.PNG;
                share(SHARE_MEDIA.WEIXIN_CIRCLE, image, "");
            }
        }
    }

    /******
     * 分享文件
     * @param var1
     * @param var2
     */
    private void share(SHARE_MEDIA var1, UMImage var2, String content) {
        if (shareAction == null) {
            shareAction = new ShareAction((Activity) getPresenterContext()).setCallback(null);
        }
        shareAction.setPlatform(var1)//传入平台
                .withText(content)
                .withMedia(var2);//分享内容
        shareAction.share();
    }
}
