package com.rv.share;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.base.utils.ui.datetime.selector.util.TextUtil;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.SPConstance;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.component.utils.Cookie;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.basic.BaseStatusActivity;
import com.rv.share.bean.PersonShareBean;
import com.rv.share.presenter.SharePresenter;
import com.yuyife.okgo.OkGoUtil;

import java.util.HashMap;
import java.util.Map;

import butterknife.BindView;
import butterknife.OnClick;

public class ShareActivity extends BaseStatusActivity<SharePresenter> {
    @BindView(R2.id.tv_weixin)
    TextView tvWeixin;
    @BindView(R2.id.tv_weixin_circle)
    TextView tvWxCircle;
    @BindView(R2.id.tv_bill)
    TextView tvBill;
    @BindView(R2.id.tv_more)
    TextView tvMore;

    @BindView(R2.id.tv_amount)
    TextView tvAmount;
    @BindView(R2.id.tv_person_inval)
    TextView tvPersonInval;
    @BindView(R2.id.tv_person_use)
    TextView tvPersonUse;
    @BindView(R2.id.img_parent)
    ImageView imgParent;
    @BindView(R2.id.tv_parent_phone)
    TextView tvParentPhone;
    @BindView(R2.id.tv_ruler)
    TextView tvRuler;

    @BindView(R2.id.tv_more_detail)
    TextView tvMoreDetail;
    private String shareUrl;

    @Override
    public void onShowResult(int requestType, BaseBean result) {

        if (requestType == 0) {
            PersonShareBean bean = (PersonShareBean) result;
            if (bean.isRel() && bean.getData() != null) {
                setView(bean.getData());
            }
        }
    }

    private void setView(PersonShareBean.PersonShareInfo data) {
        tvAmount.setText(data.getTotalIncome() + "元");
        tvPersonInval.setText(data.getInviteNumber() + "人");
        tvPersonUse.setText(data.getActivatedNumber() + "人");
        if (TextUtils.isEmpty(data.getLeaderHeadUrl()) && TextUtil.isEmpty(data.getLeaderUsername())) {
            ((View) tvParentPhone.getParent().getParent()).setVisibility(View.INVISIBLE);
        } else {
            ((View) tvParentPhone.getParent().getParent()).setVisibility(View.VISIBLE);
            if (!TextUtils.isEmpty(data.getLeaderHeadUrl())) {
                GlideManager.getInstance(getApplicationContext()).loadImage(data.getLeaderHeadUrl(), imgParent);
            }
            if (!TextUtils.isEmpty(data.getLeaderUsername())) {
                tvParentPhone.setText(data.getLeaderUsername());
            }
        }
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        mPresenter.setShareImage(this, tvWeixin, tvWxCircle, tvBill, tvMore);
        getPersonShareInfo();
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_share;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("我的邀请码");
    }

    private void getPersonShareInfo() {
        if (!TextUtils.isEmpty(OkGoUtil.getToken())) {
            Map<String, Object> map = new HashMap<>();
            map.put("Authorization", OkGoUtil.getToken());
            mPresenter.getDataHead(RvFrameConfig.HOST, 0, ApiConfig.HTTP_URL_PERSON_SHARE_INFO, PersonShareBean.class, map, true);
        }
    }


    @OnClick({R2.id.tv_weixin, R2.id.tv_weixin_circle, R2.id.tv_bill, R2.id.tv_more, R2.id.tv_more_detail, R2.id.ll_activation, R2.id.ll_comein, R2.id.ll_invite, R2.id.tv_ruler})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (TextUtils.isEmpty(shareUrl)) {
            String code = Cookie.getStringValue(getApplicationContext(), SPConstance.USER_JSON_CODE, "");
            shareUrl = RvFrameConfig.HOST + "/h5/appHtml/view/invitationCourtesyShare.html?code=" + code + "_P0101";
        }
        if (id == R.id.tv_weixin) {
            mPresenter.shareWx(shareUrl, "新人专享大礼包，快去领！", "  ");
        } else if (id == R.id.tv_weixin_circle) {
            mPresenter.shareWxC(shareUrl, "【滴房车】新人专享大礼包，快去领！", "  ");
        } else if (id == R.id.tv_bill) {
            startActivity(ReativeBillActivity.getIntent(this, shareUrl));
        } else if (id == R.id.tv_more) {
            mPresenter.shareMore(shareUrl, "新人专享大礼包，快去领！", "  ");
        } else if (id == R.id.tv_more_detail) {
            startActivity(PopularizeActivity.getIntent(getApplicationContext(), 0));
        } else if (id == R.id.ll_activation) {
            startActivity(PopularizeActivity.getIntent(getApplicationContext(), 2));
        } else if (id == R.id.ll_invite) {
            startActivity(PopularizeActivity.getIntent(getApplicationContext(), 1));
        } else if (id == R.id.ll_comein) {
            startActivity(PopularizeActivity.getIntent(getApplicationContext(), 0));
        } else if (id == R.id.tv_ruler) {
            startActivity(new Intent(getApplicationContext(), ShareRulerActivity.class));
        }
    }

}
