package com.rv.points.adapter;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.rv.component.utils.DateUtils;
import com.rv.points.R;
import com.rv.points.bean.SignRecordBean;
import com.rv.points.view.DateUtil;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateAdapter extends BaseAdapter {

    private Context context;
    private List<Integer> days = new ArrayList<>();

    private List<Integer> singRecords = new ArrayList<>();
    private int today;


    //签到成功的回调方法，相应的可自行添加签到失败时的回调方法

    public DateAdapter(Context context) {
        this.context = context;
        int maxDay = DateUtil.getCurrentMonthLastDay();//获取当月天数
        Calendar calendar = Calendar.getInstance();
        today = calendar.get(Calendar.DAY_OF_MONTH);
        for (int i = 0; i < DateUtil.getFirstDayOfMonth() - 1; i++) {
            //DateUtil.getFirstDayOfMonth()获取当月第一天是星期几，星期日是第一天，依次类推
            days.add(0);
        }
        for (int i = 0; i < maxDay; i++) {
            days.add(i + 1);
        }
    }

    @Override
    public int getCount() {
        return days.size();
    }

    @Override
    public Object getItem(int i) {
        return days.get(i);
    }

    @Override
    public long getItemId(int i) {
        return i;
    }

    @Override
    public View getView(final int i, View view, ViewGroup viewGroup) {
        ViewHolder viewHolder;
        if (view == null) {
            view = LayoutInflater.from(context).inflate(R.layout.item_gv, null);
            viewHolder = new ViewHolder();
            view.setTag(viewHolder);
        } else {
            viewHolder = (ViewHolder) view.getTag();
        }
        viewHolder.tv = view.findViewById(R.id.tvWeek);
        viewHolder.rlItem = view.findViewById(R.id.rlItem);
        viewHolder.ivStatus = view.findViewById(R.id.ivStatus);
        if (today == i) {
            viewHolder.tv.setText("今天");
        } else {
            viewHolder.tv.setText(days.get(i) + "");
        }
        if (days.get(i) == 0) {
            viewHolder.rlItem.setVisibility(View.GONE);
        }
        if (singRecords != null && singRecords.contains(i)) {
            viewHolder.ivStatus.setImageResource(R.drawable.icon_signed);
            viewHolder.ivStatus.setVisibility(View.VISIBLE);
        } else {
            if (today > i) {
                viewHolder.ivStatus.setImageResource(R.drawable.icon_unsign);
                viewHolder.ivStatus.setVisibility(View.VISIBLE);
            } else {
                viewHolder.ivStatus.setVisibility(View.INVISIBLE);
            }
        }

        return view;
    }

    /*****
     * 设置已经签到的界面
     */
    public void setSignData(List<SignRecordBean.SignRecord> list) {
        singRecords.clear();
        for (SignRecordBean.SignRecord record : list) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(record.getCrtTime());
            this.singRecords.add(Integer.valueOf(calendar.get(Calendar.DAY_OF_MONTH)));
        }
        notifyDataSetChanged();
    }

    class ViewHolder {
        RelativeLayout rlItem;
        TextView tv;
        ImageView ivStatus;
    }

}
