package com.rv.tourism.adapter;

import android.widget.ImageView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.rv.tourism.R;
import com.rv.tourism.bean.BeanTourAround;

/**
 * 推荐路线  adapter
 */
public class RecommendedRouteAdapter extends BaseQuickAdapter<BeanTourAround.DataBeanX.DataBean, BaseViewHolder> {
    public RecommendedRouteAdapter() {
        super(R.layout.rv_item_recommended_route);
    }

    @Override
    protected void convert(BaseViewHolder helper, BeanTourAround.DataBeanX.DataBean item) {
        GlideManager.getInstance(mContext).loadImage(item.getCover(),  (ImageView)helper.getView(R.id.iv_icon));
         helper.setText(R.id.tv_title,item.getName());
        helper.setText(R.id.tv_price,String.format("￥%1$s%2$s",item.getPrice(),item.getUnit()));
    }

    public void addNewData(BeanTourAround bean) {
        mData.clear();
        addData(bean.getData().getData());
        notifyDataSetChanged();
    }
}
