package com.rv.home.rv.module.ui.main.home.order;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.entity.MultiItemEntity;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseFragment;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshLayout;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshView;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.home.rv.module.ui.main.home.order.adapter.CompletedAdapter;
import com.rv.home.rv.module.ui.main.home.order.bean.OrderListBean;
import com.yuyife.okgo.OkGoUtil;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

import butterknife.BindView;

/**
 * Created :Auser
 * Date: 2019/5/28.
 * Desc:已完成
 */

public class CompletedFragment extends BaseFragment<CommonPresenter> implements BaseQuickAdapter.RequestLoadMoreListener, SimpleRefreshLayout.OnSimpleRefreshListener {

    @BindView(R2.id.recyclerView)
    RecyclerView recyclerView;
    @BindView(R2.id.refresh)
    SimpleRefreshLayout mSimpleRefreshLayout;
    CompletedAdapter mAdapter;
    private int mPage;
    private int countPage;
    private final int TYPE_REQUEST_EVALUATION = 1;

    public static CompletedFragment getInstance(int type) {
        Bundle bundl = new Bundle();
        bundl.putInt("type", type);
        CompletedFragment fragment = new CompletedFragment();
        fragment.setArguments(bundl);
        return fragment;
    }

    @Override
    public int getViewLayout() {
        return R.layout.common_refresh;
    }

    @Override
    protected void initView(Bundle savedInstanceState) {

        recyclerView.setLayoutManager(new LinearLayoutManager(_mActivity));
        mAdapter = new CompletedAdapter(new ArrayList<MultiItemEntity>());
        mAdapter.setOnLoadMoreListener(this, recyclerView);
        mSimpleRefreshLayout.setHeaderView(new SimpleRefreshView(_mActivity));
        mSimpleRefreshLayout.setOnSimpleRefreshListener(this);
        recyclerView.setAdapter(mAdapter);
        mAdapter.setOnItemChildClickListener(new BaseQuickAdapter.OnItemChildClickListener() {
            @Override
            public void onItemChildClick(BaseQuickAdapter adapter, View view, int position) {
                OrderListBean.DataBeanX.DataBean dataBean = (OrderListBean.DataBeanX.DataBean) adapter.getItem(position);
                int i = view.getId();
                if (i == R.id.tv_process) {
                    startActivityForResult(EvaluationActivity.getIntent(_mActivity, dataBean), TYPE_REQUEST_EVALUATION);
                } else if (i == R.id.tv_camp_process) {
                    startActivityForResult(EvaluationActivity.getIntent(_mActivity, dataBean), TYPE_REQUEST_EVALUATION);
                }
            }
        });

        mAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                OrderListBean.DataBeanX.DataBean dataBean = (OrderListBean.DataBeanX.DataBean) adapter.getItem(position);
                if (1 == dataBean.getType()) {
                    startActivityForResult(OrderDetailActivity.getIntent(_mActivity, dataBean), 1);
                } else if (2 == dataBean.getType()) {
                    startActivityForResult(TravelOrderDetailsActivity.getIntent(_mActivity, dataBean), 2);
                } else if (3 == dataBean.getType()) {
                    startActivity(MemberOrderDetailsActivity.getIntent(_mActivity, dataBean));
                }
            }
        });
    }

    @Override
    protected void loadData(Bundle savedInstanceState) {

    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        switch (requestType) {
            case 0:
                processData((OrderListBean) result);
                break;
        }
    }

    @Override
    public void onLazyInitView(@Nullable Bundle savedInstanceState) {
        super.onLazyInitView(savedInstanceState);
        onRefresh();
    }

    @Override
    public void onRefresh() {
        mPage = 1;
        orderData(mPage);
    }

    @Override
    public void onLoadMoreRequested() {
        if (mPage >= countPage) {
            mAdapter.loadMoreEnd();

        } else {
            mPage++;
            orderData(mPage);

        }
    }


    private void orderData(int page) {
        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null)
            headMap.put("Authorization", OkGoUtil.getToken());
        Map<String, Object> mapData = new LinkedHashMap<>();
        mapData.put("page", page);
        mapData.put("limit", 10);
        mapData.put("status", 6);
        mPresenter.getData(RvFrameConfig.VEHICLE_ORDER, 0, ApiConfig.HTTP_URL_ORDER_LIST, OrderListBean.class, mapData, headMap, page == 1 ? true : false);
    }

    /**
     * 处理请求数据
     *
     * @param bean
     */
    private void processData(OrderListBean bean) {
        if (mPage == 1) {
            countPage = bean.getData().getTotalPage();
            mAdapter.addNewData(bean);
            mSimpleRefreshLayout.onRefreshComplete();
            if (bean.getData().getTotalCount() == 0) {
                mAdapter.setEmptyView(getEmptyView(recyclerView, -1, _mActivity.getString(R.string.rv_select_not_data)));
                mAdapter.notifyDataSetChanged();
            }

        } else {
            mAdapter.addData(bean.getData().getData());
            mAdapter.loadMoreComplete();
        }
    }


}
