package com.rv.home.rv.module.ui.main.home.dialog;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.ruiwenliu.wrapper.dialog.BasePopupWindow;
import com.ruiwenliu.wrapper.util.ViewHolder;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.ui.main.home.adapter.CarAttributeAdapter;
import com.rv.home.rv.module.ui.main.home.bean.CarAttributeListBean;

import java.util.List;

/**
 * Created :Auser
 * Date: 2019/5/16.
 * Desc:menu属性选择
 */

public class CarAttributePw extends BasePopupWindow {

    public CarAttributeAdapter attributeAdapter;

    public CarAttributePw(@NonNull Activity context) {
        super(context);
        setOutsideTouchable(false);
    }

    @Override
    public int getViewLayout() {
        return R.layout.rv_pw_car_attr;
    }

    @Override
    public void helper(ViewHolder helper) {
        super.helper(helper);
        helper.setOnClickListener(R.id.fl_dismiss, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });
        RecyclerView recyclerView = helper.getView(R.id.recyclerView);
        recyclerView.setLayoutManager(new LinearLayoutManager(getDialogContext()));
        attributeAdapter = new CarAttributeAdapter();
        recyclerView.setAdapter(attributeAdapter);
        attributeAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
//                attributeAdapter.setSelectItem(position);
                dismiss();
            }
        });
    }

    public void setNewData(List<CarAttributeListBean.DataBean.CataBean.ChildrenBean> list) {
        if (attributeAdapter != null && list != null) {
            attributeAdapter.setNewData(list);
        }
    }

    public void setOnItemClick(BaseQuickAdapter.OnItemClickListener onItemClick) {
        if (attributeAdapter != null && onItemClick != null) {
            attributeAdapter.setOnItemClickListener(onItemClick);
        }
    }


//    @Override
//    public void showAsDropDown(View anchor) {
//        if (Build.VERSION.SDK_INT >= 24) {
//            Rect visibleFrame = new Rect();
//            anchor.getGlobalVisibleRect(visibleFrame);
//            int height = anchor.getResources().getDisplayMetrics().heightPixels - visibleFrame.bottom;
////            int height = anchor.getResources().getDisplayMetrics().heightPixels;
//            setHeight(height);
//        }
//        super.showAsDropDown(anchor);
//    }




    /**
     *
     * @param anchor v
     */
    public  void showPopupWindow(final View anchor) {
        if (Build.VERSION.SDK_INT >= 24) {
            Rect visibleFrame = new Rect();
            anchor.getGlobalVisibleRect(visibleFrame);
            int height = anchor.getResources().getDisplayMetrics().heightPixels - visibleFrame.bottom;
            this.setHeight(height);
            this.showAsDropDown(anchor, 0, 0);
        } else {
            this.showAsDropDown(anchor, 0, 0);
        }
    }



    private void fullScreenImmersive(View view) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            int uiOptions = View.SYSTEM_UI_FLAG_LAYOUT_STABLE | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_FULLSCREEN;
            view.setSystemUiVisibility(uiOptions);
        }
    }
}
