package com.rv.home.rv.module.ui.main.home.adapter;

import android.support.v4.content.ContextCompat;
import android.widget.TextView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.ui.main.home.bean.CarAttributeListBean;

/**
 * Created :Auser
 * Date: 2019/5/16.
 * Desc:菜单属性Adapter
 */

public class CarAttributeAdapter extends BaseQuickAdapter<CarAttributeListBean.DataBean.CataBean.ChildrenBean, BaseViewHolder> {
    private int selectPosition;

    public CarAttributeAdapter() {
        super(R.layout.rv_item_car_attribute);
    }

    @Override
    protected void convert(BaseViewHolder helper, CarAttributeListBean.DataBean.CataBean.ChildrenBean item) {
        TextView tvContent = helper.getView(R.id.tv_content);
        tvContent.setText(item.getName());
        if (selectPosition == getPosition(item)) {
            tvContent.setTextColor(ContextCompat.getColor(mContext, R.color.colorAuxiliaryYellow));
            helper.setGone(R.id.iv_select, true);
        } else {
            tvContent.setTextColor(ContextCompat.getColor(mContext, R.color.textMain));
            helper.setGone(R.id.iv_select, false);
        }


    }
    public int getIndex(String attrName) {
        int index = -1;
        for (int i = 0; i < mData.size(); i++) {
            if (mData.get(i).getName().equals(attrName)) {
                index = i;
                break;
            }
        }

        return index;
    }

    /**
     * 设置选中的Item
     *
     * @param attrName
     */
    public void setSelectItem(String attrName) {
        selectPosition = getIndex(attrName);
        notifyDataSetChanged();
    }

    private int getPosition(CarAttributeListBean.DataBean.CataBean.ChildrenBean item) {
        return getData().indexOf(item);
    }
}
