package com.rv.component.utils;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.widget.Button;
import android.widget.TextView;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

/**
 * Created by Administrator on 2016/11/22.
 */

public class MyUtils {

    public static void setTvTop(Context context, int res, TextView tv) {
        Drawable top = context.getResources().getDrawable(res);
        top.setBounds(0, 0, top.getMinimumWidth(), top.getMinimumHeight());
        tv.setCompoundDrawables(null, top, null, null);
    }

    public static void setTvRight(Context context, int res, TextView tv) {
        Drawable right = context.getResources().getDrawable(res);
        right.setBounds(0, 0, right.getMinimumWidth(), right.getMinimumHeight());
        tv.setCompoundDrawables(null, null, right, null);
    }

    public static void setTvLeft(Context context, int res, TextView tv) {
        Drawable left = context.getResources().getDrawable(res);
        left.setBounds(0, 0, left.getMinimumWidth(), left.getMinimumHeight());
        tv.setCompoundDrawables(left, null, null, null);
    }

    public static void setTvRight(Context context, int res, Button btn) {
        Drawable right = context.getResources().getDrawable(res);
        right.setBounds(0, 0, right.getMinimumWidth(), right.getMinimumHeight());
        btn.setCompoundDrawables(null, null, right, null);
    }

    /**
     * 时间选择器，格式化时间(年月日)
     *
     * @param date
     * @return
     */
    public static String getDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(date);
    }

    /**
     * 获取当前日期
     *
     * @return
     */
    public static String getCurrentDate() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date curDate = new Date(System.currentTimeMillis());//获取当前时间
        return formatter.format(curDate);
    }

    /**
     * 获取未来第n天的日期
     */
    public static String getFetureDate(int n) {
        Calendar c = Calendar.getInstance();
        c.set(Calendar.DAY_OF_YEAR, c.get(Calendar.DAY_OF_YEAR) + n);
        SimpleDateFormat mFormat = new SimpleDateFormat("yyyy-MM-dd");
        c.getTime();
        return mFormat.format(c.getTime());
    }

    public static String getFetureDate2(int n) {
        Calendar c = Calendar.getInstance();
        c.set(Calendar.DAY_OF_YEAR, c.get(Calendar.DAY_OF_YEAR) + n);
        SimpleDateFormat mFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        c.getTime();
        return mFormat.format(c.getTime());
    }


    /**
     * 获取指定日期未来第n天的日期
     */
    public static String getFetureDate(String data, int n) {
        SimpleDateFormat mFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        try {
        c.setTime(mFormat.parse(data));
        c.set(Calendar.DATE, c.get(Calendar.DATE) + n);
        c.getTime();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return mFormat.format(c.getTime());
    }

    /**
     * 获取过去第n天的日期
     *
     * @param n
     * @return
     */
    public static String getPastDate(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) - n);
        Date today = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String result = format.format(today);
        return result;
    }

    /**
     * 获取过去第n天的日期(Date)
     *
     * @param n
     * @return
     */
    public static Date getPastDateFormat(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) - n);
        return calendar.getTime();
    }

    /**
     * 获取当前日期
     *
     * @return
     */
    public static Date getCurrentDateFormat() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    /**
     * 截取日期
     *
     * @param str
     * @return
     */
    public static String cutOutDate(String str) {
        String backDate;
        if (str.length() > 10) {
            backDate = str.split(" ")[0].substring(5);
        } else if (12 > str.length() && str.length() > 6) {
            backDate = str.substring(5);
        } else {
            backDate = str;
        }
        return backDate;
    }

    /**
     * 判断当前日期是星期几
     *
     * @param pTime 设置的需要判断的时间  //格式如2012-09-08
     * @return dayForWeek 判断结果
     * @Exception 发生异常
     */
    public static String getWeek(String pTime) {
        String week = "";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        try {
            c.setTime(format.parse(pTime));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        if (c.get(Calendar.DAY_OF_WEEK) == Calendar.SUNDAY) {
            week += "日";
        }
        if (c.get(Calendar.DAY_OF_WEEK) == Calendar.MONDAY) {
            week += "一";
        }
        if (c.get(Calendar.DAY_OF_WEEK) == Calendar.TUESDAY) {
            week += "二";
        }
        if (c.get(Calendar.DAY_OF_WEEK) == Calendar.WEDNESDAY) {
            week += "三";
        }
        if (c.get(Calendar.DAY_OF_WEEK) == Calendar.THURSDAY) {
            week += "四";
        }
        if (c.get(Calendar.DAY_OF_WEEK) == Calendar.FRIDAY) {
            week += "五";
        }
        if (c.get(Calendar.DAY_OF_WEEK) == Calendar.SATURDAY) {
            week += "六";
        }
        return week;
    }

    private static ThreadLocal<SimpleDateFormat> DateLocal = new ThreadLocal<>();

    /**
     * 判断是否为今天(效率比较高)
     *
     * @param day 传入的 时间  "2016-06-28 10:10:30" "2016-06-28" 都可以
     * @return true今天 false不是
     * @throws ParseException
     */
    public static boolean isToday(String day) {

        Calendar pre = Calendar.getInstance();
        Date predate = new Date(System.currentTimeMillis());
        pre.setTime(predate);

        Calendar cal = Calendar.getInstance();
        Date date = null;
        try {
            date = getDateFormat().parse(day);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        cal.setTime(date);
        if (cal.get(Calendar.YEAR) == (pre.get(Calendar.YEAR))) {
            int diffDay = cal.get(Calendar.DAY_OF_YEAR)
                    - pre.get(Calendar.DAY_OF_YEAR);
            if (diffDay == 0) {
                return true;
            }
        }
        return false;
    }

    /**
     * 是否在今天之前
     */
    public static boolean beforeToday(String day) {

        Calendar pre = Calendar.getInstance();
        Date predate = new Date(System.currentTimeMillis());
        pre.setTime(predate);

        Calendar cal = Calendar.getInstance();
        Date date = null;
        try {
            date = getDateFormat().parse(day);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        cal.setTime(date);
        if (cal.get(Calendar.YEAR) == (pre.get(Calendar.YEAR))) {
            int diffDay = cal.get(Calendar.DAY_OF_YEAR)
                    - pre.get(Calendar.DAY_OF_YEAR);
            if (diffDay <= 0) {
                return true;
            }
        }
        return false;
    }

    /**
     * 是否在今天之后
     */
    public static boolean afterToday(String day) {

        Calendar pre = Calendar.getInstance();
        Date predate = new Date(System.currentTimeMillis());
        pre.setTime(predate);

        Calendar cal = Calendar.getInstance();
        Date date = null;
        try {
            date = getDateFormat().parse(day);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        cal.setTime(date);
        if (cal.get(Calendar.YEAR) == (pre.get(Calendar.YEAR))) {
            int diffDay = cal.get(Calendar.DAY_OF_YEAR)
                    - pre.get(Calendar.DAY_OF_YEAR);
            if (diffDay >= 0) {
                return true;
            }
        }
        return false;
    }

    /**
     * 获取日期格式
     *
     * @return
     */
    public static SimpleDateFormat getDateFormat() {
        if (null == DateLocal.get()) {
            DateLocal.set(new SimpleDateFormat("yyyy-MM-dd", Locale.CHINA));
        }
        return DateLocal.get();
    }

    /**
     * 保留2位小数
     */
    public static String getDoublePrice(String str) {
        if (str != null && !"".equals(str)) {
            return String.format("%.2f", Double.valueOf(str));
        } else {
            return "0.00";
        }
    }

    /**
     * 保留2位小数
     */
    public static String getDoublePrice(double d) {
        return String.format("%.2f", d);
    }

    /**
     * 获取指定日期
     *
     * @param str
     * @return
     */
    public static String getAppointDate(String str, int n) {
        DateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = fmt.parse(str);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.set(Calendar.DATE, now.get(Calendar.DATE) - n);
        Date today = now.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String result = format.format(today);
        return result;
    }

}

