package com.rv.component.utils;

import android.content.Context;

import com.rv.component.utils.log.Log2File;
import com.rv.component.utils.log.LogLevel;

/********
 * 日志
 *
 * 1 将日志输入到控制台
 * 2 将日志打印至本地文件中
 *   （日志是否打开）
 *
 */
public class LogUtil {
    public static final String TAG = LogUtil.class.getName();
    public static Boolean LOG_ENABLE = true;

    private static Context mContext;

    /*********
     * 在程序的入口设置日志开关
     * LogUtil.setLogEnable(BuildConfig.debug)
     * @param b
     */
    public static void setLogEnable(boolean b, Context context) {
        LOG_ENABLE = b;
        mContext = context;
    }

    public static Context getContext() {
        return mContext;
    }

    public static void i(String msg) {
        i(TAG, msg);
    }

    public static void i(String tag, String msg) {
        if (LOG_ENABLE) {
            android.util.Log.i(tag, msg);
            Log2File.log2file(LogLevel.I, tag, msg);
        }
    }

    public static void v(String msg) {
        v(TAG, msg);
    }

    public static void v(String tag, String msg) {
        if (LOG_ENABLE) {
            android.util.Log.v(tag, msg);
            Log2File.log2file(LogLevel.V, tag, msg);
        }
    }

    public static void d(String msg) {
        d(TAG, msg);
    }

    public static void d(String tag, String msg) {
        if (LOG_ENABLE) {
            android.util.Log.d(tag, msg);
            Log2File.log2file(LogLevel.D, tag, msg);
        }
    }

    public static void w(String msg) {
        w(TAG, msg);
    }

    public static void w(String tag, String msg) {
        if (LOG_ENABLE) {
            android.util.Log.w(tag, msg);
            Log2File.log2file(LogLevel.W, tag, msg);
        }
    }

    public static void e(String msg) {
        e(TAG, msg);
    }

    public static void e(String tag, String msg) {
        if (LOG_ENABLE) {
            android.util.Log.e(tag, msg);
            Log2File.log2file(LogLevel.E, tag, msg);
        }
    }
}
