package com.rv.rvmine.member.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.rv.rvmine.R;

public class MemberCardView extends LinearLayout {

    private TextView tvText;
    private ImageView imgIcon;
    private String text;
    private int res;
    private int type = 0;

    private int[] imgDiscounts = {
            R.drawable.member_discount_6,
            R.drawable.member_discount_7,
            R.drawable.member_discount_8
    };

    private int[] imgFreeDays = {
            R.drawable.member_free_day_5,
            R.drawable.member_free_day_12,
            R.drawable.member_free_day_28
    };

    public MemberCardView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.member_view);
        type = ta.getInt(R.styleable.member_view_card_type, 0);
        ta.recycle();
        initView();
    }

    private void initView() {
        View view = LayoutInflater.from(getContext()).inflate(R.layout.item_member_view, null);
        tvText = view.findViewById(R.id.tv_text);
        imgIcon = view.findViewById(R.id.img_ic);
        if (type == 0) {
            text = "永久%d折";
        } else if (type == 1) {
            text = "%d天免费用车";
        } else if (type == 2) {
            tvText.setText(R.string.tv_outdoors_act);
            imgIcon.setImageResource(R.drawable.member_icon_free);
        }
        addView(view);
    }

    /******
     * 设置
     */
    public void setValue(int value) {

        if (tvText != null && imgIcon != null) {
            switch (type) {
                case 0:
                    if (value == 60) {
                        res = imgDiscounts[0];
                    } else if (value == 70) {
                        res = imgDiscounts[1];
                    } else
                        res = imgDiscounts[2];
                    tvText.setText(String.format(text, (int) (value / 10)));
                    imgIcon.setImageResource(res);
                    break;
                case 1:
                    if (value == 28) {
                        res = imgFreeDays[2];
                    } else if (value == 12) {
                        res = imgFreeDays[1];
                    } else
                        res = imgFreeDays[0];
                    tvText.setText(String.format(text, value));
                    imgIcon.setImageResource(res);
                    break;
                default:
                    break;
            }
        }
    }

}
