package com.rv.rvmine.member.view;

import android.content.Context;
import android.graphics.Color;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.rv.rvmine.R;
import com.rv.rvmine.bean.MemberListBean;

public class MemberCardDetailView extends LinearLayout {

    private int state = 0;  // 未选中状态
    private MemberListBean.MemberCard memberCard;
    private RelativeLayout rl_content;
    private TextView tv_price;
    private TextView tv_discount;
    private TextView tv_free_day;
    private TextView tv_type;

    private MyClickListener clickListener;

    public MemberCardDetailView(Context context, MemberListBean.MemberCard memberCard, MyClickListener clickListener) {
        super(context);
        this.memberCard = memberCard;
        this.clickListener = clickListener;
        initView();
    }

    private void initView() {

        View view = LayoutInflater.from(getContext()).inflate(R.layout.item_member_detail_view, null);

        rl_content = view.findViewById(R.id.rl_content);
        tv_price = view.findViewById(R.id.tv_price);
        tv_discount = view.findViewById(R.id.tv_discount);
        tv_free_day = view.findViewById(R.id.tv_free_day);
        tv_type = view.findViewById(R.id.tv_type_icon);

        if (memberCard != null) {

            SpannableString s = new SpannableString("￥" + memberCard.getPrice());

            s.setSpan(new AbsoluteSizeSpan(12, true), 0, 1, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            s.setSpan(new AbsoluteSizeSpan(18, true), 1, s.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            s.setSpan(new ForegroundColorSpan(Color.parseColor("#FFB74B")), 1, s.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            tv_price.setText(s);

            tv_discount.setText("永久" + memberCard.getDiscount() / 10 + "折租车");
            tv_free_day.setText(memberCard.getNumber() + "天免费租车");

            tv_type.setText(memberCard.getName());
            switch (memberCard.getLevel()) {
                case 1:
                    tv_type.setBackgroundResource(R.drawable.member_icon_reg_members);
                    break;
                case 2:
                    tv_type.setBackgroundResource(R.drawable.member_icon_gold_membership);
                    break;
                case 3:
                    tv_type.setBackgroundResource(R.drawable.member_icon_dia_membership);
                    break;
            }
        }

        rl_content.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {

                if (state == 0) {
                    state = 1;
                    rl_content.setBackgroundResource(R.drawable.shape_rv_bg_member_selected);
                    clickListener.onClick(MemberCardDetailView.this);
                }
            }
        });

        addView(view);
    }

    public void unSelect() {
        state = 0;
        rl_content.setBackgroundResource(R.drawable.shape_rv_bg_member_unselected);
    }

    public void select() {
        state = 1;
        rl_content.setBackgroundResource(R.drawable.shape_rv_bg_member_selected);
    }

    public interface MyClickListener {
        void onClick(MemberCardDetailView view);
    }
}
