package com.rv.rvmine.member.adapter;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.rv.rvmine.R;
import com.rv.rvmine.bean.MemberListBean;
import com.rv.rvmine.member.view.MemberCardDetailView;
import com.rv.rvmine.member.view.MemberCardView;

import java.util.List;

public class MemberListAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private Context mContext;
    private List<MemberListBean.MemberCard> mData;
    private int selectPosition;
    private PayListener payListener;

    public interface PayListener {
        void pay(MemberListBean.MemberCard card);
    }

    public MemberListAdapter(@Nullable List<MemberListBean.MemberCard> data, Context context, PayListener listener) {
        this.mContext = context;
        this.payListener = listener;
        initData(data);
    }

    private void initData(List<MemberListBean.MemberCard> data) {
        selectPosition = 1;
        data.add(0, null);
        mData = data;
    }


    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {

        if (i == 0) {
            return new HeadViewHolder(LayoutInflater.from(mContext).inflate(R.layout.view_member_privilege, viewGroup, false));
        }
        return new CommonViewHolder(LayoutInflater.from(mContext).inflate(R.layout.item_member_detail, viewGroup, false));
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int i) {

        MemberListBean.MemberCard bean = mData.get(i);
        if (bean == null) {
            setHeadViewData((HeadViewHolder) viewHolder);
        } else {
            setCommonViewData((CommonViewHolder) viewHolder, bean);
        }
    }

    @Override
    public int getItemCount() {
        return mData.size();
    }

    @Override
    public int getItemViewType(int position) {
        if (mData.get(position) == null) {
            return 0;
        }
        return 1;
    }


    private void setHeadViewData(final HeadViewHolder viewHolder) {
        SpannableString spannableString = new SpannableString(viewHolder.tv_agreement.getText());
        spannableString.setSpan(new ForegroundColorSpan(Color.parseColor("#FFB74B")), 6, spannableString.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        viewHolder.tv_agreement.setText(spannableString);
        viewHolder.img_agree.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                if (viewHolder.agreeState == 1) {
                    viewHolder.agreeState = 0;
                    viewHolder.img_agree.setImageResource(R.drawable.common_icon_radio_unche);
                    viewHolder.btn_buy.setEnabled(false);
                } else {
                    viewHolder.agreeState = 1;
                    viewHolder.img_agree.setImageResource(R.drawable.common_icon_selected);
                    viewHolder.btn_buy.setEnabled(true);
                }
            }
        });

        viewHolder.btn_buy.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (payListener != null) {
                    payListener.pay(mData.get(selectPosition));
                }
            }
        });

        viewHolder.gridview.removeAllViews();
        for (int i = 1; i < mData.size(); i++) {
            if (mData.get(i) != null) {
                final int finalI = i;
                MemberCardDetailView cardDetailView = new MemberCardDetailView(mContext, mData.get(i), new MemberCardDetailView.MyClickListener() {

                    @Override
                    public void onClick(MemberCardDetailView view) {
                        selectPosition = finalI;
                        viewHolder.btn_buy.setText("立即开通" + mData.get(selectPosition).getName());
                        for (int i = 0; i < viewHolder.gridview.getChildCount(); i++) {
                            if (view != viewHolder.gridview.getChildAt(i)) {
                                ((MemberCardDetailView) viewHolder.gridview.getChildAt(i)).unSelect();
                            }
                        }
                    }
                });
                if (i == selectPosition) {
                    cardDetailView.select();
                    viewHolder.btn_buy.setText("立即开通" + mData.get(selectPosition).getName());
                }
                viewHolder.gridview.addView(cardDetailView);
            }
        }
    }

    protected void setCommonViewData(CommonViewHolder viewHolder, MemberListBean.MemberCard bean) {
        if (!TextUtils.isEmpty(bean.getName())) {
            viewHolder.tv_member_type.setText(bean.getName());
            viewHolder.btn_buy.setText("立即开通" + bean.getName());
        }

        viewHolder.btn_buy.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

            }
        });
        if (!TextUtils.isEmpty(bean.getIcon()))
            new GlideManager(mContext).loadImage(bean.getIcon(), viewHolder.img_icon);

        SpannableString spannableString = new SpannableString(bean.getName() + bean.getPrice() + "元 (永久)");
        spannableString.setSpan(new ForegroundColorSpan(Color.parseColor("#F25B5B")), bean.getName().length(), spannableString.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        viewHolder.tv_member_type_price_time.setText(spannableString);

        if (!TextUtils.isEmpty(bean.getDescribe())) {
            viewHolder.tv_describe.setText(bean.getDescribe());
        }
        viewHolder.mcv_discount.setValue(bean.getDiscount());
        viewHolder.mcv_free_day.setValue(bean.getNumber());
    }

    public void setDate(List<MemberListBean.MemberCard> data) {
        initData(data);
        notifyDataSetChanged();
    }

    public class HeadViewHolder extends RecyclerView.ViewHolder {

        int agreeState = 1; // 选中状态
        LinearLayout gridview;
        TextView tv_agreement;
        ImageView img_agree;
        Button btn_buy;

        public HeadViewHolder(@NonNull View itemView) {
            super(itemView);
            gridview = itemView.findViewById(R.id.gridview);
            tv_agreement = itemView.findViewById(R.id.tv_agreement);
            img_agree = itemView.findViewById(R.id.img_agree);
            btn_buy = itemView.findViewById(R.id.btn_buy);
        }
    }

    public class CommonViewHolder extends RecyclerView.ViewHolder {
        TextView tv_member_type;
        MemberCardView mcv_discount, mcv_free_day, mcv_free_outdoors;
        ImageView img_icon;
        TextView tv_member_type_price_time;
        TextView tv_describe;
        Button btn_buy;

        public CommonViewHolder(@NonNull View itemView) {
            super(itemView);
            tv_member_type = itemView.findViewById(R.id.tv_member_type);
            mcv_discount = itemView.findViewById(R.id.mcv_discount);
            mcv_free_day = itemView.findViewById(R.id.mcv_free_day);
            mcv_free_outdoors = itemView.findViewById(R.id.mcv_free_outdoors);
            img_icon = itemView.findViewById(R.id.img_icon);
            tv_member_type_price_time = itemView.findViewById(R.id.tv_member_type_price_time);
            tv_describe = itemView.findViewById(R.id.tv_describe);
            btn_buy = itemView.findViewById(R.id.btn_buy);
        }
    }
}
