package com.rv.home.rv.module.ui.main.home.adapter;

import android.widget.CheckBox;
import android.widget.CompoundButton;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ruiwenliu.wrapper.util.RxJavaManager;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.ui.main.home.bean.DrivingListBean;

import java.util.ArrayList;
import java.util.List;

import io.reactivex.functions.Consumer;

/**
 * Created :Auser
 * Date: 2019/5/24.
 * Desc:驾驶员列表
 */

public class DrivingListAdapter extends BaseQuickAdapter<DrivingListBean.DataBeanX.DataBean, BaseViewHolder> {
    public DrivingListAdapter() {
        super(R.layout.rv_item_driving_list);
    }

    @Override
    protected void convert(BaseViewHolder helper, final DrivingListBean.DataBeanX.DataBean item) {
        helper.setText(R.id.tv_name, item.getName());
        helper.setText(R.id.tv_phone, item.getPhone());
        helper.setText(R.id.tv_id_card, item.getIdCard());
        if (item.isCheck()) {
            helper.setChecked(R.id.cb_driving, true);
        }else {
            helper.setChecked(R.id.cb_driving, false);
        }
        helper.addOnClickListener(R.id.tv_edit);
        helper.setOnCheckedChangeListener(R.id.cb_driving, new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
              int position =getPosition(item);
              setItemState(isChecked, position);

            }
        });
    }

    public int getPosition(DrivingListBean.DataBeanX.DataBean item){
        return mData.indexOf(item);
    }

    /**
     * 设置驾驶员选中状态
     * @param check
     * @param position
     */
    public void setItemState(boolean check,int position){
        mData.get(position).selectType=check==true?1:0;
        notifyItemChanged(position);
    }

    /**
     * 获取选中的驾驶员数据
     * @return
     */
    public List<DrivingListBean.DataBeanX.DataBean> getSelectItem(){
        List<DrivingListBean.DataBeanX.DataBean>  list=new ArrayList<>();
       for (DrivingListBean.DataBeanX.DataBean dataBean:mData){
           if(dataBean.selectType==1){
               list.add(dataBean);
           }
       }
        return list;
    }

}
