package com.rv.travel;

import android.content.Context;
import android.widget.ImageView;
import android.widget.Toast;

import com.base.utils.tools.android.IntentUtil;
import com.rv.travel.api.ApiUtil;
import com.rv.travel.api.OnApiResponseCallback;
import com.rv.travel.bean.BeanCheckCollection;
import com.rv.travel.bean.BeanOrderPay;
import com.rv.travel.bean.BeanRim;
import com.rv.travel.fragment.TravelFragmentCommitOrder;
import com.rv.travel.fragment.TravelWebFragment;
import com.rv.travel.other.OtherClickListener;
import com.rv.travel.other.OtherOption;
import com.rv.travel.other.TravelFragmentActivity;

public class GoOtherUtil {
    public static String travelDetailId = "0";
    public static BeanRim mBean;
    private static String isCollection = "0";  //0 没有收藏  1 收藏
    private static String id;
    //去旅游详情
    public static void goTravelDetailWeb(final BeanRim bean, final Context context) {
        GoOtherUtil.travelDetailId = bean.getId();
        mBean = bean;
        String url = "https://xxtest.upyuns.com/h5/appHtml/view/travelDetails.html?id=" + bean.getId();
        //TravelFragmentActivity.currentFragment = TravelWebFragment.getInstance(url);
        TravelFragmentActivity.currentFragment = TravelWebFragment.getInstance(url);
        final OtherOption otherOption = new OtherOption();
        otherOption.setTitle("详情");
        otherOption.setCollect(true);
        otherOption.setShare(true);
        otherOption.setClickListener(new OtherClickListener() {
            @Override
            public void onBack() {
                TravelFragmentActivity.getInstance().finish();

            }

            @Override
            public void onButton() {

            }

            @Override
            public void onButtonCollect(final ImageView buttonCollect) {
                if ("1".equals(isCollection)) {
                     ApiUtil.cancelCollection(id, "1", new OnApiResponseCallback<String, String>() {
                         @Override
                         public void done(String data, String errorMessage) {
                             Toast.makeText(context, "取消收藏成功", Toast.LENGTH_SHORT).show();
                             buttonCollect.setImageResource(R.drawable.travel_rv_collect);
                             isCollection = "0";
                         }
                     });

                }else {
                    ApiUtil.addCollection("2", bean.getId(), bean.getName(), bean.getCover(), bean.getPrice(), bean.getUnit(), new OnApiResponseCallback<String, String>() {
                        @Override
                        public void done(String data, String errorMessage) {
                            Toast.makeText(context, "收藏成功", Toast.LENGTH_SHORT).show();
                            buttonCollect.setImageResource(R.drawable.home_icon_campsite_selected);
                            isCollection = "1";
                        }
                    });

                }
            }

            @Override
            public void onButtonShare() {

            }
        });
        TravelFragmentActivity.option = otherOption;


        ApiUtil.getIsCollection(bean.getId(), new OnApiResponseCallback<BeanCheckCollection, String>() {
            @Override
            public void done(BeanCheckCollection data, String errorMessage) {
                isCollection = data.getStatus();
                 id = data.getId();
                ImageView buttonCollect = otherOption.getLayout().buttonCollect;
                if ("1".equals(data.getStatus())){
                    buttonCollect.setImageResource(R.drawable.home_icon_campsite_selected);
                }else {
                    buttonCollect.setImageResource(R.drawable.travel_rv_collect);
                }
            }
        });


        IntentUtil.startActivity(context, TravelFragmentActivity.class);
    }

    //去确认订单
    public static void goTravelCommitOrder(String data,final Context context) {
        TravelFragmentActivity.currentFragment = TravelFragmentCommitOrder.getInstance(data);
        OtherOption otherOption = new OtherOption();
        otherOption.setTitle("确认下单");
        otherOption.setClickListener(new OtherClickListener() {
            @Override
            public void onBack() {
                GoOtherUtil.goTravelDetailWeb(GoOtherUtil.mBean, context);
            }

            @Override
            public void onButton() {

            }

            @Override
            public void onButtonCollect(ImageView buttonCollect) {

            }

            @Override
            public void onButtonShare() {

            }
        });
        TravelFragmentActivity.option = otherOption;
        IntentUtil.startActivity(context, TravelFragmentActivity.class);
    }
}
