package com.test.rv;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.ruiwenliu.wrapper.base.BaseActivity;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseWrapperFragment;
import com.ruiwenliu.wrapper.util.listener.SwitchFragment;
import com.ruiwenliu.wrapper.weight.CustomScrollViewPager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.camp.CampFragment;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.home.rv.module.ui.main.adapter.TabAdapter;
import com.rv.home.rv.module.ui.main.home.HomeFragment;
import com.rv.rvmine.MineFragment;
import com.rv.tourism.R2;
import com.rv.tourism.TourismFragment;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;


public class MainActivity extends BaseActivity<CommonPresenter> {

//    @BindView(R2.id.pager_view_fragment)
    CustomScrollViewPager viewPager;
    @BindView(R2.id.iv_home)
    ImageView ivHome;
    @BindView(R2.id.tv_home)
    TextView tvHome;
    @BindView(R2.id.iv_travel)
    ImageView ivTravel;
    @BindView(R2.id.tv_travel)
    TextView tvTravel;
    @BindView(R2.id.iv_camp)
    ImageView ivCamp;
    @BindView(R2.id.tv_camp)
    TextView tvCamp;
    @BindView(R2.id.iv_found)
    ImageView ivFound;
    @BindView(R2.id.tv_found)
    TextView tvFound;
    @BindView(R2.id.iv_mine)
    ImageView ivMine;
    @BindView(R2.id.tv_mine)
    TextView tvMine;
    private TabAdapter mAdapter;
    private final int TYPE_HOME_PAGE = 0;//首页
    private final int TYPE_TRAVEL = 1;//旅行
    private final int TYPE_CAMP = 2;//营地
    private final int TYPE_FOUND = 3;//旅行
    private final int TYPE_MINE = 4;//我的
    private long exitTime = 0;

    public static Intent getIntent(Context context) {
        return new Intent(context, MainActivity.class);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_main;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        viewPager=  findViewById(R.id.pager_view_fragment);
        showTitle(false);
        mAdapter = new TabAdapter(getSupportFragmentManager(), getListFragment());
        viewPager.setAdapter(mAdapter);
//        viewPager.setOffscreenPageLimit(3);
        setCurrent(TYPE_HOME_PAGE);

        SwitchFragment.setFragmentSelected(new SwitchFragment.ChangeFragment() {
            @Override
            public void changge(int postion) {
                setCurrent(postion);
            }
        });
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {

    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }


    @OnClick({R2.id.rl_home, R2.id.rl_travel, R2.id.rl_camp, R2.id.rl_found, R2.id.rl_mine})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id ==R.id.rl_home ){
            setCurrent(TYPE_HOME_PAGE);
        }else if (id == R.id.rl_travel){
            setCurrent(TYPE_TRAVEL);
        }else if (id ==R.id.rl_camp){
            setCurrent(TYPE_CAMP);
        }else if (id ==  R.id.rl_found){
//            setCurrent(TYPE_FOUND);
        }else if (id == R.id.rl_mine){
            setCurrent(TYPE_MINE);
        }
    }

    private List<BaseWrapperFragment> getListFragment() {
        List<BaseWrapperFragment> list = new ArrayList<>();
        list.add(HomeFragment.getInstance(TYPE_HOME_PAGE));
        list.add(TourismFragment.getInstance(TYPE_TRAVEL));
        list.add(CampFragment.getInstance(TYPE_CAMP));
//        list.add(MineFragment.getInstance(TYPE_FOUND));
        list.add(MineFragment.getInstance(TYPE_MINE));
        return list;
    }

    /**
     * 设置切换
     *
     * @param index
     */
    public void setCurrent(int index) {
        setViewStyle(ivHome, tvHome, index == TYPE_HOME_PAGE);
        setViewStyle(ivTravel, tvTravel, index == TYPE_TRAVEL);
        setViewStyle(ivCamp, tvCamp, index == TYPE_CAMP);
        setViewStyle(ivFound, tvFound, index == TYPE_FOUND);
        setViewStyle(ivMine, tvMine, index == TYPE_MINE);
        viewPager.setCurrentItem(index, false);
    }

    /**
     * 设置view的样式
     */
    private void setViewStyle(ImageView imageView, TextView textView, boolean isTrue) {
        imageView.setSelected(isTrue);
        textView.setTextColor(ContextCompat.getColor(this, isTrue ? R.color.gray_FFB74B : R.color.textMain));
    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        mAdapter.getCurrentFragment().onActivityResult(requestCode, resultCode, data);

    }


    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getKeyCode() == KeyEvent.KEYCODE_BACK) {
            if (event.getAction() == KeyEvent.ACTION_DOWN && event.getRepeatCount() == 0) {
                exitApp();
            }
            return true;
        }
        return super.dispatchKeyEvent(event);
    }

    /**
     * 退出APP
     */
    private void exitApp() {
        if (System.currentTimeMillis() - exitTime > 2000) {
            showToast("再按一次，退出程序");
            exitTime = System.currentTimeMillis();
        } else {
            finish();
        }
    }
}
