package com.xxrv.wallet.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;

import com.alibaba.android.arouter.launcher.ARouter;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.util.ViewHolder;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.home.rv.module.ApiConfig;
import com.xxrv.wallet.R;
import com.xxrv.wallet.R2;
import com.xxrv.wallet.dialog.PayPassDialog;
import com.xxrv.wallet.dialog.VerifyAccountHintDialog;
import com.xxrv.wallet.presenter.WalletPresenter;
import com.xxrv.wallet.view.PayPassView;
import butterknife.BindView;
import butterknife.OnClick;

/**
 * 提现
 */
public class WithdrawActivity extends BaseStatusActivity<WalletPresenter> {

    @BindView(R2.id.et_account_number)
    EditText etAccountNumber;
    @BindView(R2.id.et_withdrawal_amount)
    EditText etWithdrawalAmount;

    public static Intent getIntent(Context context) {
        return new Intent(context, WithdrawActivity.class);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_withdraw;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("提现");
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @OnClick({R2.id.tv_item_withdraw, R2.id.tv_item_withdrawal_rules})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.tv_item_withdraw){
             //提现
            showHint();

        }else if (id == R.id.tv_item_withdrawal_rules){
            //提现规则
            ARouter.getInstance().build(Constance.ACTIVITY_URL_WEBVIEW)
                    .withString("title", "提现规则")
                    .withString("url", ApiConfig.HTTP_URL_CAR_TYPE_NOTICE)
                    .withInt("type", 20)
                    .navigation();
        }
    }

    /**
     * 提现
     */
    private void showHint() {
        final String accountNumber = etAccountNumber.getText().toString().trim();
        if (TextUtils.isEmpty(accountNumber)){
            showToast("账户不能为空！");
            return;
        }

        final String withdrawalAmount = etWithdrawalAmount.getText().toString().trim();
        if (TextUtils.isEmpty(withdrawalAmount)){
            showToast("提现金额不能为空！");
            return;
        }

        new VerifyAccountHintDialog(mActivity) {
            @Override
            public void helper(ViewHolder helper) {
                super.helper(helper);
                helper.setText(R.id.tv_pay_amount,withdrawalAmount +"元");
                helper.setText(R.id.tv_account_number,accountNumber);
                helper.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        int id = v.getId();
                        if (id == R.id.tv_item_ok) {
                            payDialog();
                            dismiss();
                        } else if (id == R.id.tv_item_cancel) {
                            dismiss();
                        }
                    }
                }, R.id.tv_item_ok, R.id.tv_item_cancel);
            }
        }.show();
    }

    /**
     * 支付密码
     */
    private void payDialog() {
        final PayPassDialog payPassDialog = new PayPassDialog(this);
        payPassDialog.setOutColse(false);
        payPassDialog.getPayViewPass().setPayClickListener(new PayPassView.OnPayClickListener() {
            @Override
            public void onPassFinish(String passContent) {
                //输入完成
                 showToast("提现成功！");
                startActivity(CashWithdrawalDetailsActivity.getIntent(mActivity));
                payPassDialog.dismiss();
            }

            @Override
            public void onPayClose() {
               payPassDialog.dismiss();
            }

            @Override
            public void onPayForget() {
               //忘记密码
                payPassDialog.dismiss();
            }
        });
    }
}
