package com.rv.share.presenter;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import com.base.utils.ui.datetime.selector.util.TextUtil;
import com.rv.component.utils.DisplayUtil;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.share.R;
import com.rv.share.ReativeBillActivity;
import com.rv.share.view.ShareChoiceDialog;
import com.umeng.socialize.ShareAction;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.media.UMWeb;

public class SharePresenter extends CommonPresenter {
    private ShareAction shareAction = null;
    private int drawableSize = 50;
    private String mUrl = null;
    private String mTitle = null;
    private String mDescript = null;
    private ShareChoiceDialog dialog = null;

    public void setShareImage(Context context, TextView tvWeixin, TextView tvWxCircle, TextView tvBill, TextView tvMore) {
        Drawable drawable = context.getResources().getDrawable(R.drawable.icon_share_weixin);
        drawable.setBounds(0, 0, DisplayUtil.dip2px(context, drawableSize), DisplayUtil.dip2px(context, drawableSize));
        tvWeixin.setCompoundDrawables(null, drawable, null, null);
        tvWeixin.setVisibility(View.VISIBLE);

        Drawable drawable1 = context.getResources().getDrawable(R.drawable.icon_share_wx_circle);
        drawable1.setBounds(0, 0, DisplayUtil.dip2px(context, drawableSize), DisplayUtil.dip2px(context, drawableSize));
        tvWxCircle.setCompoundDrawables(null, drawable1, null, null);
        tvWxCircle.setVisibility(View.VISIBLE);

        Drawable drawable2 = context.getResources().getDrawable(R.drawable.icon_share_code);
        drawable2.setBounds(0, 0, DisplayUtil.dip2px(context, drawableSize), DisplayUtil.dip2px(context, drawableSize));
        tvBill.setCompoundDrawables(null, drawable2, null, null);
        tvBill.setVisibility(View.VISIBLE);

        Drawable drawable3 = context.getResources().getDrawable(R.drawable.icon_share_more);
        drawable3.setBounds(0, 0, DisplayUtil.dip2px(context, drawableSize), DisplayUtil.dip2px(context, drawableSize));
        tvMore.setCompoundDrawables(null, drawable3, null, null);
        tvMore.setVisibility(View.VISIBLE);
    }

    public void shareWx(String mUrl, String mTitle, String mDescript) {
        if (shareAction == null) {
            shareAction = new ShareAction((Activity) getPresenterContext()).setCallback(shareListener);
        }

        UMImage image = new UMImage(getPresenterContext(), R.drawable.share_logo);
        UMWeb web = new UMWeb(mUrl);
        web.setTitle(mTitle);//标题
        web.setThumb(image);  //缩略图
        web.setDescription(mDescript);//描述

        shareAction.setPlatform(SHARE_MEDIA.WEIXIN)//传入平台
                .withMedia(web);
        shareAction.share();
    }


    /******
     * 分享地址
     */
    public void shareWxC(String mUrl, String mTitle, String mDescript) {
        if (shareAction == null) {
            shareAction = new ShareAction((Activity) getPresenterContext()).setCallback(shareListener);
        }
        UMImage image = new UMImage(getPresenterContext(), R.drawable.share_logo);
        UMWeb web = new UMWeb(mUrl);
        web.setTitle(mTitle + " " + mDescript);//标题
        web.setThumb(image);  //缩略图
        shareAction.setPlatform(SHARE_MEDIA.WEIXIN_CIRCLE)//传入平台
                .withMedia(web);
        shareAction.share();
    }

    /******
     * 分享地址
     */
    public void shareMore(String mUrl, String mTitle, String mDescript) {
        this.mUrl = mUrl;
        this.mTitle = mTitle;
        this.mDescript = mDescript;
        if (dialog == null) {
            dialog = new ShareChoiceDialog.Builder(getPresenterContext())
                    .setShareListener(myListener)
                    .setCopyVisiable(true)
                    .setWxVisiable(true)
                    .setWxCVisiable(true)
                    .setQQVisiable(true)
                    .setBillVisiable(true)
                    .create();
        }
        dialog.show();
    }


    private UMShareListener shareListener = new UMShareListener() {
        @Override
        public void onStart(SHARE_MEDIA share_media) {

        }

        @Override
        public void onResult(SHARE_MEDIA share_media) {
            Log.e("xxxxxxxxxx", "onResult:");
        }

        @Override
        public void onError(SHARE_MEDIA share_media, Throwable throwable) {
            Log.e("xxxxxxxxxx", "shareonError:" + throwable.getMessage());
        }

        @Override
        public void onCancel(SHARE_MEDIA share_media) {
            Log.e("xxxxxxxxxx", "shareonCancel");
        }
    };

    private ShareChoiceDialog.ShareListener myListener = new ShareChoiceDialog.ShareListener() {
        @Override
        public void copyShare() {
            if (!TextUtils.isEmpty(mUrl)) {
                copy(mUrl);
            }
        }

        @Override
        public void wxShare() {
            if (!TextUtils.isEmpty(mUrl))
                shareWx(mUrl, mTitle, mDescript);
        }

        @Override
        public void wxCShare() {
            if (!TextUtils.isEmpty(mUrl))
                shareWxC(mUrl, mTitle, mDescript);
        }

        @Override
        public void qqShare() {
            if (!TextUtil.isEmpty(mUrl)) {
//                 shareQQ(SHARE_MEDIA.QQ, mUrl);
            }
        }

        @Override
        public void billShare() {
            // 跳转海报
            getPresenterContext().startActivity(ReativeBillActivity.getIntent(getPresenterContext(), mUrl));
        }

        @Override
        public void close() {
        }
    };

    /*******
     * 复制地址
     * @param url
     */
    private void copy(String url) {
        ClipboardManager cm = (ClipboardManager) getPresenterContext().getSystemService(Context.CLIPBOARD_SERVICE);
        ClipData mClipData = ClipData.newRawUri("Label", Uri.parse(url));
        cm.setPrimaryClip(mClipData);
        Toast.makeText(getPresenterContext(), "复制成功", Toast.LENGTH_SHORT).show();
    }

}
