package com.xxrv.coupon.fragment;

import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseFragment;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshLayout;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshView;
import com.xxrv.coupon.R;
import com.xxrv.coupon.R2;
import com.xxrv.coupon.adapter.UsedCouponAdapter;
import com.xxrv.coupon.adapter.WaitCouponAdapter;
import com.xxrv.coupon.api.CouponApi;
import com.xxrv.coupon.bean.CouponBean;
import com.xxrv.coupon.presenter.CouponAllPresenter;
import com.yuyife.okgo.OkGoUtil;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

import butterknife.BindView;

/**
 * 优惠券  已使用
 */
public class UsedCouponFragment extends BaseFragment<CouponAllPresenter> implements SimpleRefreshLayout.OnSimpleRefreshListener {

    @BindView(R2.id.rv_content)
    RecyclerView rvContent;
    @BindView(R2.id.refresh)
    SimpleRefreshLayout mSimpleRefreshLayout;

    UsedCouponAdapter mAdapter;
    
    public static UsedCouponFragment getInstance(int type) {
        Bundle bundl = new Bundle();
        bundl.putInt("type", type);
        UsedCouponFragment fragment = new UsedCouponFragment();
        fragment.setArguments(bundl);
        return fragment;
    }

    @Override
    public int getViewLayout() {
        return R.layout.fragment_coupon_wait;
    }

    @Override
    protected void initView(Bundle savedInstanceState) {
        mSimpleRefreshLayout.setHeaderView(new SimpleRefreshView(_mActivity));
        mSimpleRefreshLayout.setOnSimpleRefreshListener(this);


        mAdapter = new UsedCouponAdapter();
        rvContent.setLayoutManager(new LinearLayoutManager(_mActivity, LinearLayoutManager.VERTICAL, false));
        rvContent.setAdapter(mAdapter);

    }

    @Override
    protected void loadData(Bundle savedInstanceState) {
        geDataList();
    }

    /**
     * 请求数据
     *
     */
    private void geDataList() {
        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null)
            headMap.put("Authorization", OkGoUtil.getToken());
        Map<String, Object> map = new LinkedHashMap<>();
        map.put("type", "1");
        mPresenter.getData(RvFrameConfig.HOST,0, CouponApi.HTTP_URL_COUPON_LIST, CouponBean.class, map,headMap,false);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        mSimpleRefreshLayout.onRefreshComplete();
        processData((CouponBean) result);
    }

    private void processData(CouponBean bean) {
        if (bean !=null && bean.getData()!=null && bean.getData().size() >0) {
            mAdapter.getData().clear();
            mAdapter.addData(bean.getData());
            mAdapter.notifyDataSetChanged();
        }else {
            mAdapter.setEmptyView(getEmptyView(rvContent, -1, "暂无优惠券"));
            mAdapter.notifyDataSetChanged();
        }
    }


    @Override
    public void onRefresh() {
        geDataList();
    }
}
