package com.rv.home.rv.module.ui.main.home.order.adapter;

import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;

import com.chad.library.adapter.base.BaseMultiItemQuickAdapter;
import com.chad.library.adapter.base.entity.MultiItemEntity;
import com.ruiwenliu.wrapper.util.BaseGlideHolder;
import com.rv.component.utils.Cookie;
import com.rv.component.utils.DateUtils;
import com.rv.home.R;
import com.rv.home.rv.module.ui.main.home.order.bean.OrderListBean;
import com.rv.home.rv.module.ui.main.home.order.view.MyTimerView;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * Created :Auser
 * Date: 2019/5/28.
 * Desc:全部订单
 */

public class OrderListAdapter extends BaseMultiItemQuickAdapter<MultiItemEntity, BaseGlideHolder> {
    public static final int TYPE_FOR_PAYMENT = 1;
    public static final int TYPE_TO_TRAVEL = 2;
    public static final int TYPE_TO_MEMBER = 3;

    public OrderListAdapter(List<MultiItemEntity> data) {
        super(data);
        addItemType(TYPE_FOR_PAYMENT, R.layout.rv_item_order_for_payment);
        addItemType(TYPE_TO_TRAVEL, R.layout.rv_item_order_to_travel);
        addItemType(TYPE_TO_MEMBER, R.layout.rv_item_order_to_member);
    }

    @Override
    protected void convert(BaseGlideHolder helper, MultiItemEntity item) {
        switch (helper.getItemViewType()) {
            case TYPE_FOR_PAYMENT:
                OrderListBean.DataBeanX.DataBean dataBean = (OrderListBean.DataBeanX.DataBean) item;
                if (dataBean == null) {
                    return;
                }
                helper.setText(R.id.tv_order_time, String.format("%1$s%2$s", mContext.getString(R.string.rv_order_time), dataBean.getCrtTime()));
                if (dataBean.getOrderRentVehicleDetail() != null && dataBean.getOrderRentVehicleDetail().getStart_city_name() != null) {
                    helper.setText(R.id.tv_city, dataBean.getOrderRentVehicleDetail().getStart_city_name());
                }
                helper.loadRoundImage(mContext, dataBean.getIcon(), (ImageView) helper.getView(R.id.iv_goods), 10);
                helper.setText(R.id.tv_car_type, dataBean.getName());
                if (dataBean.getOrderRentVehicleDetail() != null) {
                    helper.setText(R.id.tv_get_time, DateUtils.timestampToString1(dataBean.getOrderRentVehicleDetail().getStart_time()));
                    helper.setText(R.id.tv_get_address, dataBean.getOrderRentVehicleDetail().getStart_addr());
                    helper.setText(R.id.tv_out_time, DateUtils.timestampToString1(dataBean.getOrderRentVehicleDetail().getEnd_time()));
                    helper.setText(R.id.tv_out_address, dataBean.getOrderRentVehicleDetail().getEnd_addr());
                }
                helper.setText(R.id.tv_price, String.format("¥%1$s", dataBean.getRealAmount()));

                /**
                 *
                 (query)
                 订单状态
                 0–删除
                 1–创建订单
                 2–取消
                 3–待付款
                 4–待出行
                 5–出行中（进行中）
                 6–已完成
                 */
                switch (dataBean.getStatusX()) {
                    case 0:
                        helper.setText(R.id.tv_order_state, "删除");
                        helper.setVisible(R.id.tv_process, false);
                        break;
                    case 2:
                        helper.setText(R.id.tv_order_state, mContext.getString(R.string.tv_cancelled));
                        helper.setVisible(R.id.tv_process, false);
                        break;
                    case 3:
                        helper.setText(R.id.tv_order_state, mContext.getString(R.string.rv_order_for_payment));
                        helper.setText(R.id.tv_process, mContext.getString(R.string.rv_to_pay_for));
                        helper.setVisible(R.id.tv_process, true);
                        setTimes(Cookie.getLongValue(mContext, "actRent"), helper, (OrderListBean.DataBeanX.DataBean) item);
                        break;
                    case 4:
                        helper.setText(R.id.tv_order_state, mContext.getString(R.string.rv_order_to_travel));
                        helper.setText(R.id.tv_process, mContext.getString(R.string.rv_to_get_car));
                        helper.setVisible(R.id.tv_process, true);
                        break;
                    case 5:
                        helper.setText(R.id.tv_order_state, mContext.getString(R.string.rv_order_have_travel));
                        helper.setText(R.id.tv_process, mContext.getString(R.string.rv_to_out_car));
                        helper.setVisible(R.id.tv_process, true);
                        break;
                    case 6:
                        helper.setText(R.id.tv_order_state, mContext.getString(R.string.rv_order_completed));
                        helper.setText(R.id.tv_process, mContext.getString(R.string.rv_to_evaluation));
                        helper.setVisible(R.id.tv_process, true);
                        break;
                    default:

                        break;
                }
                helper.addOnClickListener(R.id.tv_process);
                break;
            case TYPE_TO_TRAVEL:
                OrderListBean.DataBeanX.DataBean dataBean2 = (OrderListBean.DataBeanX.DataBean) item;
                if (dataBean2 == null) {
                    return;
                }
                if (dataBean2.getOrderTourDetail() == null) {
                    return;
                }
                helper.setText(R.id.tv_order_time, String.format("%1$s%2$s", mContext.getString(R.string.rv_order_time), dataBean2.getCrtTime()));
                helper.setText(R.id.tv_city, dataBean2.getOrderTourDetail().getStartCityName());

                helper.loadRoundImage(mContext, dataBean2.getPicture(), (ImageView) helper.getView(R.id.iv_goods), 50);
                helper.setText(R.id.tv_car_type, dataBean2.getName());
                helper.setText(R.id.tv_out_time, mContext.getString(R.string.rv_to_time) + DateUtils.timestampToString1(dataBean2.getOrderTourDetail().getStartTime()));
                helper.setText(R.id.tv_count_person, String.format("%1$s%2$s", mContext.getString(R.string.rv_to_person), dataBean2.getOrderTourDetail().getTotalNumber(), mContext.getString(R.string.rv_person)));
                helper.setText(R.id.tv_price, String.format("¥%1$s", dataBean2.getRealAmount()));

                /**
                 *
                 (query)
                 订单状态
                 0–删除
                 1–创建订单
                 2–取消
                 3–待付款
                 4–待出行
                 5–出行中（进行中）
                 6–已完成
                 */

                switch (dataBean2.getStatusX()) {
                    case 0:
                        helper.setText(R.id.tv_order_state, "删除");
                        helper.setVisible(R.id.tv_camp_process, false);
                        break;
                    case 2:
                        helper.setText(R.id.tv_order_state, mContext.getString(R.string.tv_cancelled));
                        helper.setVisible(R.id.tv_camp_process, false);
                        break;
                    case 3:
                        helper.setText(R.id.tv_order_state, mContext.getString(R.string.rv_order_for_payment));
                        helper.setText(R.id.tv_camp_process, mContext.getString(R.string.rv_to_pay_for));
                        helper.setVisible(R.id.tv_camp_process, true);
                        setTimes(Cookie.getLongValue(mContext, "actTour"), helper, (OrderListBean.DataBeanX.DataBean) item);
                        break;
                    case 4:
                        helper.setText(R.id.tv_order_state, mContext.getString(R.string.rv_order_to_travel));
                        helper.setText(R.id.tv_camp_process, mContext.getString(R.string.tv_boarding));
                        helper.setVisible(R.id.tv_camp_process, true);
                        break;
                    case 5:
                        helper.setText(R.id.tv_order_state, mContext.getString(R.string.rv_order_have_travel));
                        helper.setVisible(R.id.tv_camp_process, false);
                        helper.setVisible(R.id.tv_camp_process, false);
                        break;
                    case 6:
                        helper.setText(R.id.tv_order_state, mContext.getString(R.string.rv_order_completed));
                        helper.setText(R.id.tv_camp_process, mContext.getString(R.string.rv_to_evaluation));
                        helper.setVisible(R.id.tv_camp_process, true);
                        break;
                    default:
                        break;
                }

                helper.addOnClickListener(R.id.tv_camp_process);
                break;

            case TYPE_TO_MEMBER:
                OrderListBean.DataBeanX.DataBean dataBean3 = (OrderListBean.DataBeanX.DataBean) item;
                if (dataBean3 ==null){
                    return;
                }
                if (dataBean3.getOrderMemberDetail() ==null){
                    return;
                }

                helper.setText(R.id.tv_order_time, String.format("%1$s%2$s", mContext.getString(R.string.rv_order_time), dataBean3.getCrtTime()));
                helper.loadRoundImage(mContext, dataBean3.getPicture(), (ImageView) helper.getView(R.id.iv_goods), 10);
                helper.setText(R.id.tv_name, dataBean3.getName());
                helper.setText(R.id.tv_content,dataBean3.getOrderMemberDetail().getContent() );
                helper.setText(R.id.tv_price, String.format("¥%1$s", dataBean3.getRealAmount()));

                /**
                 *
                 (query)
                 订单状态
                 0–删除
                 1–创建订单
                 2–取消
                 3–待付款
                 4–待出行
                 5–出行中（进行中）
                 6–已完成
                 */
                switch (dataBean3.getStatusX()) {
                    case 0:
                        helper.setText(R.id.tv_order_state, "删除");
                        helper.setVisible(R.id.tv_member_pay, false);
                        break;
                    case 2:
                        helper.setText(R.id.tv_order_state, mContext.getString(R.string.tv_cancelled));
                        helper.setVisible(R.id.tv_member_pay, false);
                        break;
                    case 3:
                        helper.setText(R.id.tv_order_state, mContext.getString(R.string.rv_order_for_payment));
                        helper.setText(R.id.tv_member_pay, mContext.getString(R.string.rv_to_pay_for));
                        helper.setVisible(R.id.tv_member_pay, true);
                        break;
                    case 6:
                        helper.setText(R.id.tv_order_state, mContext.getString(R.string.rv_order_completed));
                        helper.setVisible(R.id.tv_member_pay, false);
                        break;
                    default:

                        break;
                }
                helper.addOnClickListener(R.id.tv_member_pay);
                break;
        }
    }

    public void addNewData(OrderListBean bean) {
        mData.clear();
        addData(bean.getData().getData());
        notifyDataSetChanged();

    }

    private void setTimes(long effTime, BaseGlideHolder helper, OrderListBean.DataBeanX.DataBean bean) {
        if (bean != null) {
            String crtStr = bean.getCrtTime();
            if (!TextUtils.isEmpty(crtStr)) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    Date date = format.parse(crtStr);
                    long remain = effTime - (System.currentTimeMillis() - date.getTime());
                    if (remain <= 0) {
                        helper.setText(R.id.tv_order_state, mContext.getString(R.string.tv_order_cancel));
                        switch (bean.getType()) {
                            case TYPE_FOR_PAYMENT:
                                helper.itemView.findViewById(R.id.tv_process).setVisibility(View.GONE);
                                break;
                            case TYPE_TO_TRAVEL:
                                helper.itemView.findViewById(R.id.tv_camp_process).setVisibility(View.GONE);
                                break;
                            case TYPE_TO_MEMBER:
                                helper.itemView.findViewById(R.id.tv_member_pay).setVisibility(View.GONE);
                                break;
                        }
                    } else {
                        helper.setText(R.id.tv_order_state, mContext.getString(R.string.rv_order_for_payment));
                        ((MyTimerView) helper.itemView.findViewById(R.id.tv_remain_time)).setTime(effTime, date.getTime(), timerListener);
                    }
                } catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public MyTimerView.TimerListener timerListener = new MyTimerView.TimerListener() {
        @Override
        public void onTimeFinish() {
            notifyDataSetChanged();
        }
    };
}
