package com.base.utils.ui.dialog;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.base.utils.R;
import com.base.utils.ui.datetime.picker.time.TimePickerDialog;
import com.base.utils.ui.datetime.selector.TimeSelector;

import java.util.Calendar;
import java.util.List;

/**
 * 原生 对话框工具类
 */
public class DialogUtil {


    public static class AdapterDialogRecycler extends RecyclerView.Adapter<AdapterDialogRecycler.ViewHolderDialogRecycler> {
        private List<String> values;
        private Context context;
        private OnClickListener onClickListener;
        private Dialog dialog;

        public interface OnClickListener {
            void onItemClick(String value);
        }

        public AdapterDialogRecycler(Context context, List<String> values, OnClickListener onClickListener, Dialog dialog) {
            this.context = context;
            this.values = values;
            this.onClickListener = onClickListener;
            this.dialog = dialog;
        }

        @Override
        public ViewHolderDialogRecycler onCreateViewHolder(ViewGroup parent, int viewType) {
            View view = LayoutInflater.from(context).inflate(R.layout.dialog_recycler_item, parent, false);
            return new ViewHolderDialogRecycler(view);
        }

        @Override
        public void onBindViewHolder(ViewHolderDialogRecycler holder, int position) {
            String string = values.get(position);
            holder.value.setText(string);


            holder.valueRoot.setTag(string);
            holder.valueRoot.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if (onClickListener != null) {
                        String tag = (String) view.getTag();
                        onClickListener.onItemClick(tag);
                    }
                    dialog.dismiss();
                }
            });

        }

        @Override
        public int getItemCount() {
            if (values == null)
                return 0;
            return values.size();
        }

        public class ViewHolderDialogRecycler extends RecyclerView.ViewHolder {

            LinearLayout valueRoot;
            TextView value;

            public ViewHolderDialogRecycler(View itemView) {
                super(itemView);
                valueRoot = (LinearLayout) itemView.findViewById(R.id.dialog_recycler_item_value_layout);
                value = (TextView) itemView.findViewById(R.id.dialog_recycler_item_value_text);
            }
        }
    }

    /**
     * Item Dialog
     */
    public static void showRecyclerDialog(Context context, String title, List<String> values, AdapterDialogRecycler.OnClickListener listener) {
        View view = LayoutInflater.from(context).inflate(R.layout.dialog_recycler, null);
        TextView titleView = (TextView) view.findViewById(R.id.dialog_recycler_title);
        titleView.setText(title);
        RecyclerView dialogRecyclerView = (RecyclerView) view.findViewById(R.id.dialog_recycler_view);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(context);
        linearLayoutManager.setOrientation(LinearLayoutManager.VERTICAL);
        dialogRecyclerView.setLayoutManager(linearLayoutManager);
        Dialog dialog = getDialog(context).setView(view).create();
        dialogRecyclerView.setAdapter(new AdapterDialogRecycler(context, values, listener, dialog));
        dialog.show();

    }


    /***
     * 获取一个dialog Builder实例
     *
     * @param context 上下文
     * @return AlertDialog.Builder
     */
    public static AlertDialog.Builder getDialog(Context context) {
        if (context != null)
            return new AlertDialog.Builder(context);
        return null;
    }


    /***
     * 获取一个dialog Builder实例 具有Item列表
     *
     * @param context  上下文
     * @param strings  数组Item
     * @param listener 监听器
     * @return AlertDialog.Builder
     */
    public static AlertDialog.Builder getItemDialog(Context context, CharSequence[] strings, DialogInterface.OnClickListener listener) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setItems(strings, listener);

        return builder;
    }

    /***
     * 获取一个dialog Builder实例 具有Item列表
     *
     * @param context  上下文
     * @param strings  数组Item
     * @param listener 监听器
     * @return AlertDialog.Builder
     */
    public static AlertDialog.Builder getItemDialog(Context context, CharSequence title, CharSequence[] strings, DialogInterface.OnClickListener listener) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle(title);
        builder.setItems(strings, listener);

        return builder;
    }


    /***
     * 显示系统原生日期选择器
     *
     * @param context
     */
    public static void showAndroidDatePickerDialog(Context context, DatePickerDialog.OnDateSetListener listener) {
        final Calendar ca = Calendar.getInstance();
        int mYear = ca.get(Calendar.YEAR);
        int mMonth = ca.get(Calendar.MONTH);
        int mDay = ca.get(Calendar.DAY_OF_MONTH);

        new DatePickerDialog(context, listener, mYear, mMonth, mDay).show();
    }

    /***
     * 从下方弹出显示滚轮日期选择器
     *
     * @param startTime  开始的时间 yyyy-MM-dd
     * @param endTime  开始的时间 yyyy-MM-dd
     * @param context
     */
    public static void showWheelDatePickerDialog(Context context, String startTime, String endTime, TimeSelector.ResultHandler resultHandler) {
        TimeSelector timeSelector = new TimeSelector(context, resultHandler, startTime + " 00:00", endTime + " 00:00");

        timeSelector.setIsLoop(false);
        timeSelector.setMode(TimeSelector.MODE.YMD);
        timeSelector.show();
    } /***
     * 从下方弹出显示滚轮日期选择器
     *
     * @param startTime  开始的时间 yyyy-MM-dd
     * @param endTime  开始的时间 yyyy-MM-dd
     * @param context
     */
    public static void showWheelDatePickerDialogYMDHM(Context context, String startTime, String endTime, TimeSelector.ResultHandler resultHandler) {
        TimeSelector timeSelector = new TimeSelector(context, resultHandler, startTime + " 00:00", endTime + " 00:00");

        timeSelector.setIsLoop(false);
        timeSelector.setMode(TimeSelector.MODE.YMD_HM);
        timeSelector.show();
    }


    public static final String DATEPICKER_TAG = "datepicker";
    public static final String TIMEPICKER_TAG = "timepicker";

    /**
     * 显示经典的日期选择
     */
    public static void showLikeDatePickerDialog(FragmentManager fragmentManager, com.base.utils.ui.datetime.picker.date.DatePickerDialog.OnDateSetListener listener) {
        final Calendar ca = Calendar.getInstance();
        int mYear = ca.get(Calendar.YEAR);
        int mMonth = ca.get(Calendar.MONTH);
        int mDay = ca.get(Calendar.DAY_OF_MONTH);
        final com.base.utils.ui.datetime.picker.date.DatePickerDialog datePickerDialog = com.base.utils.ui.datetime.picker.date.DatePickerDialog.newInstance(
                listener,
                mYear,
                mMonth,
                mDay,
                true);
        datePickerDialog.setVibrate(true);                  //是否振动
        datePickerDialog.setYearRange(1985, 2028);          //年份范围
        datePickerDialog.setCloseOnSingleTapDay(true);      //是否关闭显示 下一天
        datePickerDialog.show(fragmentManager, DATEPICKER_TAG);
    }

    /**
     * 显示经典的时间选择
     */
    public static void showLikeTimePickerDialog(FragmentManager fragmentManager, TimePickerDialog.OnTimeSetListener listener) {
        final Calendar ca = Calendar.getInstance();
        int mHour = ca.get(Calendar.HOUR_OF_DAY);
        int mMinute = ca.get(Calendar.MINUTE);
        final TimePickerDialog timePickerDialog = TimePickerDialog.newInstance(
                listener,
                mHour, mMinute,
                true);
        timePickerDialog.setVibrate(true);                          //是否振动
        timePickerDialog.setCloseOnSingleTapMinute(false);          //是否关闭分针转动
        timePickerDialog.show(fragmentManager, TIMEPICKER_TAG);
    }
}