package com.base.utils;

import java.io.File;

/**
 * 全局配置
 */

public class Config {

    public static boolean isBackToHome = false;                                     //是否应用为点击返回键返回到桌面
    public static boolean isScreenFull = false;                                     //是否全屏
    public static String appPrimary = "guard";                                      //程序主要的命名
    public static boolean isPrint = true;                                           //是否开启日志打印
    public static boolean isAutoSetTopBarColor = true;                              //是否开启 自动设置Activity的顶部状态栏
    public static int topBarColor = 0;                                              //自动设置Activity的顶部状态栏,的颜色
    public static boolean isShowError = true;                                       //是否开启 对话框提示（error） 给用户
    public static boolean isOpenTryCatchException = false;                          //是否开启 程序捕抓异常
    //public static boolean isOpenBaas = false;                                       //是否开启 移动后端云
    //public static boolean isOpenBugly = false;                                      //是否开启 开启异常上报分析
    //public static boolean isOpenMimc = false;                                       //是否开启 IM
    //public static boolean isOpenUmengPush = false;                                  //是否开启 友盟推送
    public static boolean isOpenHeartbeat = false;                                  //是否开启心跳
    public static long heartbeatInterval = 1000 * 30;                               //30秒心跳一次

    //日志打印
    final public static int LOG_MAX_LENGTH = 3000;                                    //日志打印一行最多3000
    //文件
    public static String appDir = File.separator + appPrimary;                        //程序主目录
    public final static String appExceptionDir = File.separator + "exception";        //程序异常目录
    public final static String appImageDir = File.separator + "image";                //缓存图片文件夹（在主目录下）
    public final static String clientApkDir = File.separator + "download";            //客户端下载apk的目录
    //logo
    public final static String animRefreshDownText = "时彩掘金";                      //下拉刷新 down
    public final static String animRefreshUpText = "掘金";                            //下拉刷新 up
    //语言
    public static String spName = "app" + appPrimary;                            //主key
    public static String spLanguage = appPrimary + "language";                   //语言key
    //程序处于前后台
    public static String spActivityUtilIsBackground = appPrimary + "_activity_util_is_background";//当前程序是否处于前台
    //全局
    public static String spGlobalWake = appPrimary + "_global_wake";             //保存是否唤醒屏幕的值


    public static void init() {
        Config.appDir = File.separator + Config.appPrimary;
        Config.spName = "app" + Config.appPrimary;
        Config.spLanguage = Config.appPrimary + "language";
        Config.spGlobalWake = Config.appPrimary + "_global_wake";
    }

}
