package com.xxrv.wallet.activity;

import android.content.Intent;
import android.os.Bundle;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.ruiwenliu.wrapper.adapter.TabAdapter;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseFragment;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.presenter.MvpPresenter;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.ruiwenliu.wrapper.weight.horizontal.GallerySnapHelper;
import com.ruiwenliu.wrapper.weight.horizontal.SpaceItemDecoration;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.home.rv.module.ui.main.home.adapter.OrderMenuAdapter;
import com.xxrv.wallet.R;
import com.xxrv.wallet.R2;
import com.xxrv.wallet.fragment.CommisionAllFragment;
import com.xxrv.wallet.fragment.CommisionFinishFragment;
import com.xxrv.wallet.fragment.CommisionUnFinishFragment;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;

public class CommissionDetailActivity extends BaseStatusActivity<CommonPresenter> {


    @BindView(R2.id.recyclerview)
    RecyclerView recyclerView;
    @BindView(R2.id.viewpager)
    ViewPager viewpager;

    private OrderMenuAdapter menuAdapter;
    private TabAdapter mAdapter;
    private int menuPosition;

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @Override
    protected int setLayout() {
        return R.layout.activity_commision;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("佣金记录");
        initRecyclerView();
        initViewpager();
    }

    /**
     * 初始化RecyclerView
     */
    private void initRecyclerView() {
        recyclerView.setLayoutManager(new GridLayoutManager(mActivity, 3));
        menuAdapter = new OrderMenuAdapter();
        recyclerView.setAdapter(menuAdapter);
        recyclerView.addItemDecoration(new SpaceItemDecoration(3));
        GallerySnapHelper snapHelper = new GallerySnapHelper();
        snapHelper.attachToRecyclerView(recyclerView);
        List<String> list = new ArrayList<>();
        String[] strs = getResources().getStringArray(R.array.commision_list);
        for (String a : strs) {
            list.add(a);
        }
        menuAdapter.setNewData(list);
        menuAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                menuAdapter.setSelectItem(position);
                viewpager.setCurrentItem(position);
            }
        });
    }

    /**
     * 初始化Viewpager
     */
    private void initViewpager() {
        mAdapter = new TabAdapter(getSupportFragmentManager(), getListFragment());
        viewpager.setAdapter(mAdapter);
        viewpager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                menuAdapter.setSelectItem(position);
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });
        viewpager.setOffscreenPageLimit(mAdapter.getCount());
        menuAdapter.setSelectItem(menuPosition);
        viewpager.setCurrentItem(menuPosition);
    }

    private List<BaseFragment> getListFragment() {
        List<BaseFragment> list = new ArrayList<>();
        list.add(CommisionAllFragment.getInstance());
        list.add(CommisionUnFinishFragment.getInstance());
        list.add(CommisionFinishFragment.getInstance());
        return list;
    }
}
