package com.rv.share.presenter;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.support.v7.widget.CardView;
import android.text.TextUtils;
import android.view.View;
import android.widget.Toast;

import com.base.utils.ui.datetime.picker.Utils;
import com.base.utils.ui.datetime.selector.util.TextUtil;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.share.ReativeBillActivity;
import com.rv.share.utils.ShareUtils;
import com.rv.share.utils.StorageUtils;
import com.rv.share.view.ShareChoiceDialog;
import com.umeng.socialize.ShareAction;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.media.UMImage;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class ReativeBillPresenter extends CommonPresenter {

    private ShareChoiceDialog dialog = null;
    private ShareAction shareAction = null;
    private View view = null;
    private Bitmap bitmap = null;
    private UMImage image = null;

    /*****
     * 保存海报
     * @param view
     */
    public void saveBill(View view) {
        if (view != null) {
            Bitmap bitmap = ShareUtils.viewConversionBitmap(view);
            File file = null;
            if (bitmap != null) {
                file = ShareUtils.saveBitmapFile(getPresenterContext(), bitmap);
            }
            if (file != null) {
                Toast.makeText(getPresenterContext(), "海报保存在" + file.getAbsolutePath(), Toast.LENGTH_LONG).show();
            }
        }
    }


    /******
     * 分享
     */
    public void share(View view) {
        this.view = view;
        if (dialog == null) {
            dialog = new ShareChoiceDialog.Builder(getPresenterContext())
                    .setShareListener(myListener)
                    .setWxVisiable(true)
                    .setWxCVisiable(true)
                    .setQQVisiable(true)
                    .create();
        }
        dialog.show();
    }

    /******
     * 分享文件
     * @param var1
     * @param var2
     */
    private void share(SHARE_MEDIA var1, UMImage var2, String content) {
        if (shareAction == null) {
            shareAction = new ShareAction((Activity) getPresenterContext()).setCallback(null);
        }
        shareAction.setPlatform(var1)//传入平台
                .withText(content)
                .withMedia(var2);//分享内容
        shareAction.share();
    }

    private ShareChoiceDialog.ShareListener myListener = new ShareChoiceDialog.ShareListener() {

        private void shareDeal() {
            if (view != null && bitmap == null) {
                bitmap = ShareUtils.viewConversionBitmap(view);
            }
            File file = null;
            if (bitmap != null) {
                file = ShareUtils.saveBitmapFile(getPresenterContext(), bitmap);
            }
            if (file != null) {
                image = new UMImage(getPresenterContext(), file);//bitmap文件
                image.compressStyle = UMImage.CompressStyle.SCALE;//大小压缩，默认为大小压缩，适合普通很大的图
                image.compressStyle = UMImage.CompressStyle.QUALITY;//质量压缩，适合长图的分享
                image.compressFormat = Bitmap.CompressFormat.PNG;
            }
        }

        @Override
        public void copyShare() {

        }

        @Override
        public void wxShare() {
            if (image == null) {
                shareDeal();
            }
            if (image != null) {
                share(SHARE_MEDIA.WEIXIN, image, "");
            }
        }

        @Override
        public void wxCShare() {

            if (image == null) {
                shareDeal();
            }
            if (image != null) {
                share(SHARE_MEDIA.WEIXIN_CIRCLE, image, "");
            }
        }

        @Override
        public void qqShare() {

        }

        @Override
        public void billShare() {

        }

        @Override
        public void close() {
        }
    };

//    @Override
//    public void detachView() {
//        super.detachView();
//        if (bitmap != null) {
//            bitmap.recycle();
//        }
//    }
}
