package com.rv.points.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;

import com.rv.component.utils.DisplayUtil;

public class WeekNavigation extends View {
    private String weeks[] = {"天", "一", "二", "三", "四", "五", "六"};
    private Context mContext;
    private Paint wordsPaint;
    private int itemWidth;
    private int itemHeight;

    public WeekNavigation(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        mContext = context;
        wordsPaint = new Paint();
        wordsPaint.setColor(Color.WHITE);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = getMeasuredWidth();
        itemHeight = DisplayUtil.sp2px(getContext(), 30);
        itemWidth = width / 7;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        wordsPaint.setTextSize(DisplayUtil.sp2px(mContext, 14));
        for (int i = 0; i < weeks.length; i++) {

            Rect rect = new Rect();
            wordsPaint.getTextBounds(weeks[i], 0, 1, rect);
            int wordWidth = rect.width();
            int wordHeight = rect.height();
            float wordX = i * itemWidth + itemWidth / 2 - wordWidth / 2;
            float wordY = itemHeight / 2 + wordWidth / 2;
            canvas.drawText(weeks[i], wordX, wordY, wordsPaint);
        }
    }

}
