package com.rv.points;

import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.frame.rv.config.RvFrameConfig;
import com.google.gson.Gson;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.component.utils.DisplayUtil;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.basic.BaseStatusActivity;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.points.bean.SignRecordBean;
import com.rv.points.bean.SignResultBean;
import com.rv.points.adapter.DateAdapter;
import com.rv.points.utils.DateUtils;
import com.rv.points.view.InnerGridView;
import com.yuyife.okgo.OkGoUtil;

import java.util.HashMap;
import java.util.Map;

import butterknife.BindView;

public class SignActivity extends BaseStatusActivity<CommonPresenter> {

    @BindView(R2.id.btn_sign)
    Button btnSign;
    @BindView(R2.id.view_month)
    InnerGridView innerGridView;
    @BindView(R2.id.tv_sign_day)
    TextView tvSignDay;
    @BindView(R2.id.img_back)
    ImageView imgBack;
    private DateAdapter dateAdapter;

    @Override
    protected int setLayout() {
        return R.layout.activity_sign;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setVisibility(View.GONE);
        btnSign.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                sign();
            }
        });
        imgBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                finish();
            }
        });
        dateAdapter = new DateAdapter(this);
        innerGridView.setAdapter(dateAdapter);
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        getSignList();
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        if (requestType == 0) {
            SignRecordBean bean = (SignRecordBean) result;
            if (bean.getData() != null && bean.getData().size() > 0) {
                SpannableString msp = new SpannableString("累计签到 " + bean.getData().size() + " 天");
                msp.setSpan(new ForegroundColorSpan(Color.parseColor("#FDC349")), 5, msp.length() - 2, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
                msp.setSpan(new AbsoluteSizeSpan(DisplayUtil.sp2px(getApplicationContext(),18)), 5, msp.length() - 2, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
                tvSignDay.setText(msp);
                dateAdapter.setSignData(bean.getData());
            }
        }
        if (requestType == 1) {
            Toast.makeText(getApplicationContext(), "签到成功", Toast.LENGTH_SHORT).show();
            getSignList();
        }
    }

    private void getSignList() {
        if (!TextUtils.isEmpty(OkGoUtil.getToken()) || 1 == 1) {
            Map<String, Object> header = new HashMap<>();
            header.put("Authorization", OkGoUtil.getToken());

            Map<String, Object> map = new HashMap<>();
            map.put("startTime", DateUtils.getBeginTime());
            map.put("endTime", DateUtils.getEndTime());
            map.put("integralRuleCode", "SIGN");
            mPresenter.getData(RvFrameConfig.HOST, 0, ApiConfig.HTTP_URL_SIGN_LIST, SignRecordBean.class, map, header, true);
        }
    }

    /*****
     * 签到
     */
    private void sign() {
        if (!TextUtils.isEmpty(OkGoUtil.getToken())) {
            Map<String, Object> header = new HashMap<>();
            header.put("Authorization", OkGoUtil.getToken());

            Map<String, Object> body = new HashMap<>();
            body.put("integralRuleCode", "SIGN");
            mPresenter.postData(RvFrameConfig.HOST, 1, ApiConfig.HTTP_URL_SIGN, SignResultBean.class, body, header, true);
        }
    }

}
