package com.rv.points;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.widget.Toast;

import com.alibaba.android.arouter.launcher.ARouter;
import com.frame.base.url.Constance;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareAPI;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.utils.SocializeUtils;

import java.util.Map;

public class Actions {

    private RvUMAuthListener listener;

    public Actions() {
    }

    /*******
     * 分享
     */
    public void share(Context context) {
        ComponentName name = new ComponentName(context, "com.xxfc.rv.MainActivity");
        Intent intent = new Intent();
        intent.setComponent(name);
        intent.putExtra("to", "home");
        context.startActivity(intent);
    }

    /******
     * 实名认证
     * @param context
     */
    public void cretification(Context context) {
        ARouter.getInstance().build(Constance.ACTIVITY_URL_IDCARDCERTIFICATION)
                .navigation((Activity) context, 1000);
    }

    /******
     * 购买会员
     * @param context
     */
    public void buymember(Context context) {
        ComponentName name = new ComponentName(context, "com.rv.member.MemberCenterActivity");
        Intent intent = new Intent();
        intent.setComponent(name);
        ((Activity) context).startActivityForResult(intent, 1001);
    }

    /*******
     * 图文评论
     * @param context
     */
    public void commentandpic(Context context) {

        ARouter.getInstance().build(Constance.ACTIVITY_URL_ORDERLIST)
                .withInt("position", 3)
                .navigation((Activity) context, 1002);
    }

    /******
     * 评论
     * @param context
     */
    public void comment(Context context) {
        ARouter.getInstance().build(Constance.ACTIVITY_URL_ORDERLIST)
                .withInt("position", 3)
                .navigation((Activity) context, 1002);
    }

    /*****
     * 签到
     * @param context
     */
    public static void sign(Context context) {
        ((Activity) context).startActivityForResult(new Intent(context, SignActivity.class), 1003);
    }

    /******
     * 绑定微信
     * @param context
     */
    public void bindwechat(Context context) {
//        if (listener == null) {
//            listener = new RvUMAuthListener(context);
//        }
//        UMShareAPI.get(context).getPlatformInfo((Activity) context, SHARE_MEDIA.WEIXIN, listener);
    }

    /*****
     * 注册
     * @param context
     */
    public void register(Context context) {

    }

    /*****
     * 房车租赁
     * @param context
     */
    public void rentrv(Context context) {
        ComponentName name = new ComponentName(context, "com.xxfc.rv.MainActivity");
        Intent intent = new Intent();
        intent.setComponent(name);
        intent.putExtra("to", "home");
        context.startActivity(intent);
    }

    /****
     * 房车购买
     * @param context
     */
    public void buyrout(Context context) {
        ComponentName name = new ComponentName(context, "com.xxfc.rv.MainActivity");
        Intent intent = new Intent();
        intent.setComponent(name);
        intent.putExtra("to", "travel");
        context.startActivity(intent);
    }

    /*****
     * 参与官方活动
     */
    public void official(Context context) {
        ComponentName name = new ComponentName(context, "com.xxfc.rv.MainActivity");
        Intent intent = new Intent();
        intent.setComponent(name);
        intent.putExtra("to", "home");
        context.startActivity(intent);
    }

    /****
     *  发表动态
     * @param context
     */
    public void publish(Context context) {
        ComponentName name = new ComponentName(context, "com.xxfc.rv.MainActivity");
        Intent intent = new Intent();
        intent.setComponent(name);
        intent.putExtra("to", "discovery");
        context.startActivity(intent);
    }

    public void commentpublish(Context context) {
        ComponentName name = new ComponentName(context, "com.xxfc.rv.MainActivity");
        Intent intent = new Intent();
        intent.setComponent(name);
        intent.putExtra("to", "discovery");
        context.startActivity(intent);
    }


    private class RvUMAuthListener implements UMAuthListener {

        private Context mContext;
        private ProgressDialog dialog;

        public RvUMAuthListener(Context context) {
            this.mContext = context;
            dialog = new ProgressDialog(mContext);
        }

        @Override
        public void onStart(SHARE_MEDIA share_media) {
            if (dialog != null)
                SocializeUtils.safeShowDialog(dialog);
        }

        @Override
        public void onComplete(SHARE_MEDIA share_media, int i, Map<String, String> map) {
            if (dialog != null) {
                SocializeUtils.safeCloseDialog(dialog);
            }
//            RxBus.post(new BindWechatEvent(map.get("iconurl"), map.get("unionid"), map.get("openid"), map.get("name")));
        }

        @Override
        public void onError(SHARE_MEDIA share_media, int i, Throwable throwable) {
            if (dialog != null)
                SocializeUtils.safeCloseDialog(dialog);
            Toast.makeText(mContext, "绑定微信失败" + throwable.getMessage(), Toast.LENGTH_SHORT).show();
        }

        @Override
        public void onCancel(SHARE_MEDIA share_media, int i) {
            if (dialog != null)
                SocializeUtils.safeCloseDialog(dialog);
        }
    }
}
