package com.xxrv.carpurchase.adapter;

import android.widget.ImageView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.base.view.StarBar;
import com.ruiwenliu.wrapper.util.BaseGlideHolder;
import com.xxrv.carpurchase.R;
import com.xxrv.carpurchase.beam.CarPurChaseListBean;

/**
 * 购房车功能列表
 */

public class CarPurChaseListAdapter extends BaseQuickAdapter<CarPurChaseListBean.DataBeanX.DataBean, BaseGlideHolder> {
    public CarPurChaseListAdapter() {
        super(R.layout.rv_item_car_purchase_list);
    }

    @Override
    protected void convert(BaseGlideHolder helper, CarPurChaseListBean.DataBeanX.DataBean item) {

        helper.loadImage(mContext, item.getIcon(), (ImageView) helper.getView(R.id.iv_goods));
        helper.setText(R.id.tv_name, item.getName());
        helper.setText(R.id.tv_context, item.getKeyword());
        float score = (float) item.getScore() / 10;
        StarBar starBar = helper.getView(R.id.starbar1);
        starBar.setStarMark(score);
        helper.setText(R.id.tv_point, score + "分");
        helper.setText(R.id.tv_price, "¥"+ item.getBuyPrice());
    }
}
