package com.xxrv.carpurchase.activity;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshLayout;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshView;
import com.xxrv.carpurchase.R;
import com.xxrv.carpurchase.R2;
import com.xxrv.carpurchase.adapter.CarPurChaseListAdapter;
import com.xxrv.carpurchase.api.CarPurchaseApi;
import com.xxrv.carpurchase.beam.CarPurChaseListBean;
import com.xxrv.carpurchase.presenter.CarPurchasePresenter;

import butterknife.BindView;

/**
 * 购车列表
 */
@Route(path = Constance.ACTIVITY_URL_CARPURCHASELIST)
public class CarPurchaseListActivity extends BaseStatusActivity<CarPurchasePresenter> implements BaseQuickAdapter.RequestLoadMoreListener, SimpleRefreshLayout.OnSimpleRefreshListener {

    @BindView(R2.id.recyclerView)
    RecyclerView recyclerView;
    @BindView(R2.id.refresh)
    SimpleRefreshLayout mSimpleRefreshLayout;

    public CarPurChaseListAdapter mAdapter;
    private int countPage;
    private int mPage;

    @Override
    protected int setLayout() {
        return R.layout.activity_car_purchase_list;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("选择车型");
        mSimpleRefreshLayout.setHeaderView(new SimpleRefreshView(mActivity));
        mSimpleRefreshLayout.setOnSimpleRefreshListener(this);

        titleView.setImageResource(R.id.iv_title_right, R.drawable.rv_rentingcar_icon_plat);
        titleView.setChildClickListener(R.id.iv_title_right, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                ARouter.getInstance()
                        .build(Constance.ACTIVITY_URL_SHOPSHOW)
                        .navigation();
            }
        });

        mAdapter = new CarPurChaseListAdapter();
        mAdapter.setOnLoadMoreListener(this, recyclerView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.setAdapter(mAdapter);

        mAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                CarPurChaseListBean.DataBeanX.DataBean bean = (CarPurChaseListBean.DataBeanX.DataBean) adapter.getItem(position);
                ARouter.getInstance()
                        .build(Constance.ACTIVITY_URL_DETAILCARPURCHASE)
                        .withString("carId", bean.getId())
                        .withString("icon", bean.getIcon())
                        .withString("name", bean.getName())
                        .withString("keyword", bean.getKeyword())
                        .withInt("score", bean.getScore())
                        .withDouble("buyPrice", bean.getBuyPrice())
                        .navigation();
            }
        });
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        onFresh();
    }

    /**
     * 刷新
     */
    private void onFresh() {
        mPage = 1;
        getCarList(mPage);
    }

    /**
     * 获取车辆列表
     */
    private void getCarList(int page) {
        mPresenter.postBodyData(1, CarPurchaseApi.HTTP_URL_FINDVEHICLEMODEPAGE_LIST, CarPurChaseListBean.class, new dataBody(page, 20), true);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        mSimpleRefreshLayout.onRefreshComplete();
        switch (requestType) {
            case 1:
                processData((CarPurChaseListBean) result);
                break;
        }
    }

    private void processData(CarPurChaseListBean bean) {
        if (mPage == 1) {
            countPage = bean.getData().getTotalPage();
            mAdapter.setNewData(bean.getData().getData());
            if (bean.getData().getTotalCount() == 0) {
                mAdapter.setEmptyView(getEmptyView(recyclerView, -1, "暂无车辆数据！"));
                mAdapter.notifyDataSetChanged();
            }
        } else {
            mAdapter.addData(bean.getData().getData());
            mAdapter.loadMoreComplete();
        }
    }

    @Override
    public void onLoadMoreRequested() {
        if (mPage >= countPage) {
            mAdapter.loadMoreEnd();
        } else {
            mPage++;
            getCarList(mPage);
        }
    }

    @Override
    public void onRefresh() {
        onFresh();
    }

    public class dataBody {
        private int page;
        private int limit;

        public dataBody(int page, int limit) {
            this.page = page;
            this.limit = limit;
        }

        public int getPage() {
            return page;
        }

        public void setPage(int page) {
            this.page = page;
        }

        public int getLimit() {
            return limit;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }
    }
}
