package com.rv.home.rv.module.ui.main.home.adapter;

import android.text.TextUtils;
import android.widget.ImageView;

import com.base.utils.ui.datetime.selector.util.TextUtil;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.ruiwenliu.wrapper.util.BaseGlideHolder;
import com.rv.home.R;
import com.rv.home.rv.module.ui.main.home.bean.HomeHotGoodListBean;
import com.rv.home.rv.module.ui.main.home.bean.HomePopularBrigade;

/**
 * Created :Auser
 * Date: 2019/5/17.
 * Desc:热门车型适配
 */

public class HotCarTypeAdapter extends BaseQuickAdapter<HomeHotGoodListBean.DataBean, BaseGlideHolder> {

    private String hotType;

    public HotCarTypeAdapter() {
        super(R.layout.rv_item_hot_car_type);
    }

    @Override
    protected void convert(BaseGlideHolder helper, HomeHotGoodListBean.DataBean bean) {
        helper.loadRoundImage(mContext,bean.getIcon(), (ImageView) helper.getView(R.id.iv_goods),6);
        helper.setText(R.id.tv_name,bean.getName());
        helper.setText(R.id.tv_content,bean.getName1());
        if (!TextUtil.isEmpty(bean.getPrice())) {
            helper.setText(R.id.tv_price, String.format("¥%1$s%2$s", bean.getPrice(), getUnit()));
        } else {
            helper.setText(R.id.tv_price, "");
        }
    }

    public void setType(String hotType) {
        this.hotType = hotType;
    }

    private String getUnit() {
        if (!TextUtils.isEmpty(hotType)) {
            switch (hotType) {
                case "1":
                    return mContext.getString(R.string.rv_one_car);
                case "2":
                    return mContext.getString(R.string.rv_one_person);
                case "3":
                    return mContext.getString(R.string.rv_day);
                default:
                    return mContext.getString(R.string.rv_one_car);
            }
        }
        return mContext.getString(R.string.rv_one_car);
    }


//    @Override
//    public int getItemCount() {
//        return 4;
//    }
    @Override
    public int getItemCount() {
        return 4;
    }
}
